<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exchanges', function (Blueprint $table) {
            $table->id();
            $table->integer("agent_id");
            $table->float("from_amount");
            $table->float("to_amount");
            $table->string("from_currency");
            $table->string("to_currency");
            $table->float("rate");
            $table->string("rate_factor")->default("multiply");
            $table->uuid('debit_journal_uuid')->nullable();   // For the sender
            $table->uuid('credit_journal_uuid')->nullable();  // For the receiver
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exchanges');
    }
};
