<?php

namespace Database\Factories;

use App\Models\Agent;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\LedgerTransfer>
 */
class LedgerTransferFactory extends Factory
{
    protected $model = \App\Models\LedgerTransfer::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        // Pick or create two distinct agents before returning data
        $agents = Agent::inRandomOrder()->take(2)->pluck('id');

        if ($agents->count() < 2) {
            $sender = Agent::factory()->create();
            do {
                $receiver = Agent::factory()->create();
            } while ($receiver->id === $sender->id);
            $senderId = $sender->id;
            $receiverId = $receiver->id;
        } else {
            $senderId = $agents[0];
            $receiverId = $agents[1];
        }

        $amount = $this->faker->randomFloat(2, 100, 5000);
        $flatFee = 2.00;
        $percentageFee = $amount * 0.015; // 1.5%
        $sendFee = round($flatFee + $percentageFee, 2);
        $senderFee = round($sendFee * 0.6, 2);
        $receiverFee = round($sendFee * 0.4, 2);
        $deliveryAmount = round($amount - $sendFee, 2);

        $currency = $this->faker->randomElement(['USD', 'EUR', 'SYP', 'TRY', 'SAR', 'EGP', 'AED', 'QAR', 'OMR']);

        return [
            'id' => (string) Str::uuid(),
            'sender_id' => $senderId,
            'receiver_id' => $receiverId,
            'amount' => $amount,
            'delivery_amount' => $deliveryAmount,
            'send_fee' => $sendFee,
            'currency' => $currency,
            'status' => 'pending',
            'reference' => strtoupper(Str::random(10)),
            'ledger_journal_uuid' => null,
            'customer_details' => json_encode([
                'name' => $this->faker->name,
                'phone' => $this->faker->phoneNumber,
            ]),
            'type' => 'agent',
            'created_by' => 1,
            'user_id' => 1,
            'sender_fee' => $senderFee,
            'receiver_fee' => $receiverFee,
            'delivery_currency' => $currency,
            'delivered_at' => null,
            'notes' => $this->faker->optional()->sentence,
            'client_id' => null,
            'created_at' => now(),
            'updated_at' => now(),
            'debit_journal_uuid' => null,
            'credit_journal_uuid' => null,
            'secret' => strtoupper(Str::random(8)),
        ];
    }
}
