<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class LedgerEntityFactory extends Factory
{
     protected $model = LedgerEntity::class;

    public function definition(): array
    {
        return [
            'type' => 'agent',
            'name' => $this->faker->company,
            'code' => $this->faker->unique()->lexify('AG-????'),
            'ledger_account_code' => $this->faker->unique()->numerify('1###'),
            'entityable_type' => \App\Models\Agent::class,
            'entityable_id' => null, // Set in factory usage
        ];
    }
}
