<?php

namespace App\Traits;

trait TransfersTrait
{
  public  function OriginalTransfer()
  {
    return $this->belongsTo(\App\Models\LedgerTransfer::class, 'transfer_id')->withoutGlobalScopes();
  }
  public function getDescription($direction = "out")
  {
    if ($direction == "out") {
      return $this->notes . '--' . $this->recipient_name;
    } else {
      return $this->receiver_note . '--' . $this->recipient_name ?? $this->client_details['name'] ?? "";
    }
  }
  public  function  getTransferType($debit)
  {
    $status = $this->status ?? "pending";
    if ($status != "pending" && $status != "completed") {
      if ($this->type == "booking" || $this->type == "Booking") {
        if ($debit !== '0') {
          // out = blue
          return '<span style="color:blue">'
            . __($this->type ?? "") . " " . __('out')
            . '</span>';
        } else {
          // in = red
          return '<span  style="color:red">'
            . __($this->type ?? "") . " " . __('in')
            . '</span>';
        }
      }
      return  __($this->type ?? "") . " " . __($status);
    }
    if ($debit !== '0') {
      // out = blue
      return '<span style="color:blue">'
        . __($this->type ?? "") . " " . __('out')
        . '</span>';
    } else {
      // in = red
      return '<span  style="color:red">'
        . __($this->type ?? "") . " " . __('in')
        . '</span>';
    }
  }
}
