<?php

namespace App\Traits;

use Carbon\Carbon;
use Abivia\Ledger\Messages\Report;
use Abivia\Ledger\Http\Controllers\ReportController;
use Abivia\Ledger\Models\LedgerAccount;
use App\Models\Agent;

class HasLedger
{
    function getAgentTrialBalance(string $agentCode)
    {
        $agent = Agent::where('code', $agentCode)->firstOrFail();

        $report = Report::fromArray([
            'name' => 'trialBalance',
            'currency' => 'USD',
            'toDate' => Carbon::now()->format('Y-m-d'),
            'parent' => [
                'uuid' => $agent->ledger_reference_uuid,
            ],
            'options' => [
                'depth' => 2, // or more depending on how deep your sub-accounts go
                'language' => ['tr'],
            ],
        ]);

        return (new ReportController())->generate($report);
    }
}
