<?php

namespace App\Traits;

use OwenIt\Auditing\Models\Audit;

trait CustomAuditable
{
    public function auditCustom(string $event, array $old, array $new): void
    {
        Audit::create([
            'user_id' => auth()->id(),
            'auditable_type' => get_class($this),
            'auditable_id' => $this->id,
            'event' => $event,
            'old_values' => $old,
            'new_values' => $new,

        ]);
    }
}
