<?php

declare(strict_types=1);

namespace App\Services\Transfer\Resolvers;

use App\Models\Agent;
use App\Models\LedgerBooking;
use App\Services\Transfer\Contracts\AccountResolverInterface;
use Abivia\Ledger\Models\LedgerAccount;

class BookingAccountResolver implements AccountResolverInterface
{
  public function resolveAccounts(LedgerBooking $transfer): array
  {

    return [
      'sender' => [
        'cash' => $this->getAgentBookingAccountCode((int)$transfer->sender_id, '11'),
        'not_delivered' => "1300",
        'commission' => "4120",
        'unearned_revenue' => "1310",
      ],
      'receiver' => [
        'cash' => $this->getAgentBookingAccountCode((int)$transfer->receiver_id, '11'),
        'not_delivered' => "1300",
        'commission' => "4120",
        'unearned_revenue' => "1310",
      ],
      'delivery_agent' => [
        'cash' => $this->getAgentBookingAccountCode((int)$transfer->receiver_id, '11'),
        'not_delivered' => "1300",
        'unearned_revenue' => "1310",
        'commission' => "4120"
      ],
      'fees' => [
        'unearned_revenue' => "1310",
        'commission' => "4120",
      ],
      'Undelivered_exchange' => "1410"
    ];
  }

  protected function getAgentBookingAccountCode(int $agentId, string $prefix): string
  {
    $agent = Agent::findOrFail($agentId);
    $real_agent_id = $agent->id; // Use direct agent ID for bookings
    $account = LedgerAccount::where('extra->agent_id', $real_agent_id)
      ->where('code', 'like', $prefix . '%')
      ->first();

    return $account->code ?? '';
  }
}
