<?php
// app/Services/PaymentService.php
namespace App\Services;

use App\Models\Invoice;
use App\Models\Payment;
use App\Models\Overdue;

class PaymentService
{
    public function recordPayment(Invoice $invoice, array $data)
    {
        $payment = Payment::create([
            'invoice_id' => $invoice->id,
            'contract_id' => $invoice->contract_id,
            'payment_date' => $data['payment_date'],
            'amount' => $data['amount'],
            'payment_method' => $data['payment_method'],
            'reference' => $data['reference'] ?? null,
            'notes' => $data['notes'] ?? null,
        ]);

        // Update invoice status
        $invoice->updateStatus();

        // If payment covers overdue, mark them as paid
        if ($invoice->status === 'paid' || $invoice->status === 'partial') {
            $this->markOverduesAsPaid($invoice, $data['amount']);
        }

        return $payment;
    }

    protected function markOverduesAsPaid(Invoice $invoice, $paidAmount)
    {
        $overdueAmount = $invoice->overdues()->where('is_paid', false)->sum('overdue_amount');

        if ($overdueAmount > 0 && $paidAmount >= $overdueAmount) {
            $invoice->overdues()->update(['is_paid' => true]);
        }
    }
}
