<?php

namespace App\Services\Partners;

use App\Interfaces\PartnerApiInterface;

// app/Services/PartnerApiFactory.php

class PartnerApiFactory
{
    public static function make(string $partnerCode): PartnerApiInterface
    {
        return match ($partnerCode) {
            'orangefer' => new OrangeferApi(),
            // 'anotherapi' => new AnotherPartnerApiService(),
            default => throw new \Exception("Unsupported partner: $partnerCode"),
        };
    }
}
