<?php

namespace App\Services\ExchangeRates\Providers;

use App\Services\ExchangeRates\Contracts\ExchangeRateProvider;
use Illuminate\Support\Facades\Http;

class HaramAltinProvider implements ExchangeRateProvider
{
    protected $endpoint;

    public function __construct()
    {
        $this->endpoint = config('services.haramaltin.endpoint');
    }

    public function getRate(string $fromCurrency, string $toCurrency, ?string $apiKey = null): ?float
    {


        if (!$apiKey || !str_contains($apiKey, '.')) {

            return null;
        }

        [$pairKey, $field] = explode('.', $apiKey);

        $response = Http::get($this->endpoint);

        if (!$response->ok()) {
            return null;
        }

        $data = $response->json();

        if (!isset($data[$pairKey][$field])) {
            return null;
        }


        return (float) $data[$pairKey][$field];
    }

    public function getAllRates(): array
    {
        $response = Http::get($this->endpoint);

        if (!$response->ok()) {
            return [];
        }

        $rawData = $response->json() ?? [];

        $nested = [];

        foreach ($rawData as $pair => $prices) {
            // Split "TRY_USD" into from/to
            [$from, $to] = explode('_', $pair);

            $nested[$from][$to] = [
                'sell' => isset($prices['satis']) ? (float) $prices['satis'] : (float) ($prices['sell'] ?? 0),
                'buy' => isset($prices['alis']) ? (float) $prices['alis'] : (float) ($prices['buy'] ?? 0),
                'sell_key' => "{$pair}.satis",
                'buy_key' => "{$pair}.alis",
                // optionally 'updated_at' => $prices['tarih'] ?? null,
            ];
        }


        return $nested;
    }
}
