<?php

namespace App\Services\ExchangeRates;

use Illuminate\Support\Facades\Cache;

class LiveRateReader
{
    public function getAll(string $source = 'harem_altin'): array
    {
        $json = Cache::store('redis')->get("live_exchange_rates:$source");

        return json_decode($json, true) ?? [];
    }

    public function getRate(string $fromCurrency, string $toCurrency, string $source = 'harem_altin'): ?float
    {
        $code = strtoupper($fromCurrency . $toCurrency);
        $rates = $this->getAll($source);

        if (!isset($rates[$code])) return null;

        return is_numeric($rates[$code]['sell']) ? (float) $rates[$code]['sell'] : null;
    }

    public function getDetailedRate(string $fromCurrency, string $toCurrency, string $source = 'harem_altin'): ?array
    {
        $code = strtoupper($fromCurrency . $toCurrency);
        $rates = $this->getAll($source);

        return $rates[$code] ?? null;
    }
}
