<?php

namespace App\Services\ExchangeRates;

use App\Exceptions\InvalidExchangeRateException;
use App\Models\Currency;
use App\Models\ExchangePrice;
use App\Services\ExchangeRates\Contracts\ExchangeRateProvider;

class ExchangePriceResolver
{
    public function getRate(string $from, string $to, string $type = 'balance'): ?float
    {
        $price = ExchangePrice::where('from_currency', $from)
            ->where('to_currency', $to)
            ->where('type', $type)
            ->first();

        if (! $price) {
            throw new InvalidExchangeRateException($from, $to);
        }

        return $this->resolve($price);
    }

    public function resolve(ExchangePrice $price): float
    {
        if ($price->price_source === 'static') {
            return (float) $price->static_price;
        }

        // Use the manager and provider to get API rate
        $manager = new ExchangeRateManager(config('Orange.exchange.default'));

        $rate = $manager->getRate(
            $price->from_currency,
            $price->to_currency,
            $price->api_key // ✅ correct usage here
        );

        if ($rate === null || round($rate) === 0) {
            throw new InvalidExchangeRateException($price->from_currency, $price->to_currency);
        }

        $diff = (float) ($price->difference ?? 0);

        return $rate + $diff;
    }
    public  function getFactor(string $from, string $to, string $type = 'balance')
    {
        try {
            if ($from == $to) {
                return "multiply";
            }
            if (isset($from) && isset($to)) {
                $price = ExchangePrice::where('from_currency', $from)
                    ->where('to_currency', $to)
                    ->where('type', $type)
                    ->first();


                if (! $price) {
                    $defaultCurrency = Currency::where('is_default', 1)->first();
                    $from_currency = Currency::where('code', $from)->first();

                    $to_currency = Currency::where('code', $to)->first();

                    if ($to == $defaultCurrency->code) {
                        return $from_currency->rate_factor;
                    } elseif ($from == $defaultCurrency->code) {
                        return $to_currency->rate_factor == "multiply" ? "divide" : "multiply";
                    }
                    return $from_currency->rate_factor;
                }

                return  $price->operation == "*" ? "multiply" : "divide";
            }
            return "multiply";
        } catch (\Exception $e) {
            return "multiply";
        }
    }
}
