<?php

namespace App\Services\Email;

use App\Services\Contracts\NotificationStrategy;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Exception;

class EmailSender implements NotificationStrategy
{
    public function send(string $to, string $message, array $meta = []): bool
    {
        $subject = $meta['subject'] ?? 'No Subject';
        $template = $meta['template'] ?? 'emails.default'; // default template
        $data = $meta['data'] ?? [];
        $from = $meta['from'] ?? null;

        try {
            Mail::send($template, $data, function ($messageObj) use ($to, $subject, $from) {
                $messageObj->to($to)->subject($subject);
                if ($from) $messageObj->from($from);
            });

            if (count(Mail::failures()) > 0) {
                Log::error("Email sending failed", ['to' => $to, 'subject' => $subject]);
                throw new Exception("Email sending failed.");
            }

            Log::info("Email sent successfully", ['to' => $to, 'subject' => $subject]);
            return true;
        } catch (Exception $e) {
            Log::error("Email sending exception", [
                'error' => $e->getMessage(),
                'to' => $to,
                'subject' => $subject
            ]);
            throw $e;
        }
    }
}
