<?php

namespace App\Services;

class DescriptionGeneratorService
{
    public static function generate($transfer): string
    {
        $type = $transfer->type;
        $data = [
            'from_currency' => $transfer->currency,
            'to_currency' => $transfer->delivery_currency,
            'amount' => $transfer->amount,
            'from' => $transfer->sender->name ?? "",
            'to' => $transfer->receiver->name ?? "",
            'description' => $transfer->description
        ];

        return trans("description.$type", $data);
    }
}
