<?php

namespace App\Services\Api;
// app/Services/Api/ApiResolver.php

use App\Interfaces\PartnerApiInterface;
use App\Models\ApiConfig;

class ApiResolver
{
    public static function resolveForAgent(int $agentId): PartnerApiInterface
    {
        $agent = \App\Models\Agent::with('apiConfig.apiType')->findOrFail($agentId);
        $apiType = $agent->apiConfig->apiType;
        $className = $apiType->class_name;

        /** @var PartnerApiInterface $apiInstance */
        $apiInstance = new $className();
        $apiInstance->setConfig(array_merge(
            ['base_url' => $agent->apiConfig->base_url],
            json_decode($agent->apiConfig->config_json, true)
        ));

        return $apiInstance;
    }
}
