<?php

namespace App\Services;

use Abivia\Ledger\Messages\Account;
use Abivia\Ledger\Messages\Reference;
use App\Models\Agent;

class AgentService
{
    public function registerAgent(array $data): Agent
    {
        $agent = Agent::create($data);

        // Create ledger account for agent
        $account = new Account();
        $account->code = 'AGT-' . $agent->code;
        $account->parent = '1100'; // Under Agent Funds
        $account->name = $agent->name;
        $account->debit = true; // Asset account
        $account->credit = false;

        $controller = new \Abivia\Ledger\Http\Controllers\LedgerAccountController();
        $response = $controller->run($account);

        // Update agent with ledger reference
        $agent->update(['ledger_uuid' => $response->account->ledgerUuid]);

        return $agent;
    }
}
