<?php
// app/Repositories/TrialBalanceRepository.php
namespace App\Repositories;

use Abivia\Ledger\Http\Controllers\ReportController;
use Abivia\Ledger\Messages\Report;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class TrialBalanceRepository
{
    protected $reportController;

    public function __construct(ReportController $reportController)
    {
        $this->reportController = $reportController;
    }

    public function getReportData()
    {
        $cacheKey = $this->getCacheKey();

        //   return Cache::remember($cacheKey, now()->addHours(1), function () {
        $report = Report::fromArray([
            'name' => 'trialBalance',
            'currency' => 'EUR',
            'fromDate' => Carbon::now()->subMonth()->format('Y-m-d'),
            'toDate' => Carbon::now()->format('Y-m-d'),
            'options' => [
                'depth' => 5,
                'language' => ['ar'],
                'useCache' => true,
            ],
        ]);

        $response = $this->reportController->generate($report);
        //  Log::info('Trial Balance Report Response', $response);
        return collect($response['accounts']);
        //    });
    }

    public function getPaginatedData($start, $length)
    {
        $fullData = $this->getReportData();

        return [
            'data' => $fullData->slice($start, $length)->values(),
            'total' => $fullData->count(),
            'filtered' => $fullData->count(),
        ];
    }

    protected function getCacheKey()
    {
        return 'trial_balance_' . md5(serialize([
            'currency' => 'EUR',
            'fromDate' => Carbon::now()->subMonth()->format('Y-m-d'),
            'toDate' => Carbon::now()->format('Y-m-d')
        ]));
    }
}
