<?php

namespace App\Policies;

use App\Models\LedgerBooking;
use App\Models\User;
use Illuminate\Auth\Access\Response;
use Illuminate\Support\Facades\Log;
use Rawilk\Settings\Facades\Settings;

class LedgerBookingPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, LedgerBooking $ledgerBooking): bool
    {
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, LedgerBooking $ledgerBooking): bool
    {
        $hoursAllowed = Settings::get("system.edit_booking_time", 24); // e.g. 24

        return $diff = $ledgerBooking->created_at->diffInHours(now()) <= $hoursAllowed;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, LedgerBooking $ledgerBooking): bool
    {
        $hoursAllowed = Settings::get("system.edit_booking_time", 24); // e.g. 24

        return $diff = $ledgerBooking->created_at->diffInHours(now()) <= $hoursAllowed;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, LedgerBooking $ledgerBooking): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, LedgerBooking $ledgerBooking): bool
    {
        return false;
    }
}
