<?php

namespace App\Policies;

use App\Models\LedgerApproval;
use App\Models\User;
use Illuminate\Auth\Access\Response;
use Rawilk\Settings\Facades\Settings;

class LedgerApprovalPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, LedgerApproval $ledgerApproval): bool
    {
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): Response
    {
        $start_time = Settings::get("system.approval_start_time", 00); // e.g. 24
        $end_time = Settings::get("system.approval_end_time", 00);
        $withinAllowedHours = now()->hour >= $start_time && now()->hour <= $end_time;

        if (! $withinAllowedHours) {
            return Response::deny('تم  تجاوز الوقت المسموح  لاجراء الإعتماد . يمكنك انشاء اعتماد   بين  ' . $start_time . ' و ' . $end_time);
        }

        return Response::allow();
        //  return now()->hour >= $start_time && now()->hour <= $end_time;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, LedgerApproval $ledgerApproval): bool
    {
        return false;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, LedgerApproval $ledgerApproval): bool
    {
        return false;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, LedgerApproval $ledgerApproval): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, LedgerApproval $ledgerApproval): bool
    {
        return false;
    }
}
