<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Interfaces\Avatar;
use App\Traits\CreatedByTrait;
use App\Traits\HasAddress;
use App\Traits\HasAvatar;
use App\Traits\HasCalculation;
use App\Traits\HasContract;
use App\Traits\HasDashboard;
use App\Traits\HasRentWallet;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Fortify\TwoFactorAuthenticatable;
use Laravel\Jetstream\HasProfilePhoto;
use Laravel\Sanctum\HasApiTokens;
use Bavix\Wallet\Traits\CanPay;
use Bavix\Wallet\Interfaces\Customer;
use Bavix\Wallet\Traits\HasWallet;
use Bavix\Wallet\Traits\HasWallets;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
use Rawilk\Settings\Models\HasSettings;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable  implements Customer, HasMedia, Avatar
{
    use HasApiTokens;
    use HasFactory;
    use HasProfilePhoto;
    use Notifiable;
    use TwoFactorAuthenticatable;
    use CanPay;
    use HasAddress;
    use HasWallet;
    use HasWallets;
    use CanPay;
    use HasAvatar;
    use HasRoles;
    use InteractsWithMedia;
    use CreatedByTrait;
    use HasSettings;
    use HasDashboard;

    use SoftDeletes;
    use TwoFactorAuthenticatable;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'code',
        'gender',
        'firstname',
        'lastname',
        'parent_id',
        'agent_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'two_factor_recovery_codes',
        'two_factor_secret',
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array<int, string>
     */


    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'created_at' => 'datetime:Y-m-d H:i:s',
        ];
    }
    public function getDefaultAvatar()
    {
        $gender = $this->gender ?? "m";
        return '/assets/img/avatars/' . $gender . '.jpg';
    }



    public static function getNextCustomerCode(): string
    {
        // Get the max numerical part of the code
        $lastCode = static::where('code', 'LIKE', 'Cus_%')
            ->select(DB::raw("MAX(CAST(SUBSTRING(code, 5) AS UNSIGNED)) as max_code"))
            ->first()
            ->max_code;

        $nextNumber = $lastCode ? $lastCode + 1 : 1;

        // Format: Cus_0000001
        return 'Cus_' . str_pad($nextNumber, 7, '0', STR_PAD_LEFT);
    }
    public function getOutstandingAmount()
    {

        return $outstangings = $this->OutstandingInvoices()->sum("total_amount");
    }
    public function scopeFilter($query, $filters)
    {
        if (!empty($filters['tenant'])) {

            $query->where('id', $filters['tenant']);
        }
        if (!empty($filters['Type'])) {

            $query->wherehas('roles', function ($q) use ($filters) {
                $q->where('name', $filters['Type']);
            });
        }
        if (!empty($filters['property'])) {
            $query->whereHas('contracts', function ($q) use ($filters) {
                $q->where('property_id', $filters['property']);
            });
        }

        return $query;
    }
    public static function getFilterableFields()
    {

        return collect([
            'Tenant' => ['type' => 'x-Mulk.select2', 'key' => 'tenant', 'options' => User::whereHas('roles', function ($q) {
                $q->where('name', 'Tenant');
            })->pluck('name', 'id')->toArray()],
            'Property' => ['key' => "property", 'type' => 'x-Mulk.select2', 'options' => Property::pluck('id', 'id')->toArray()],
            'Type' => ["key" => 'type', 'type' => 'x-Mulk.select2', 'options' => Role::pluck('name', 'name')->toArray()],
        ])
            ->filter(fn($config) => is_array($config) && isset($config['type']))
            ->toArray();
    }


    public  function getViewLink()
    {
        return  "<a href='" . url('user-list/' . $this->id) . "' target='_blank'>" . $this->name . "</a>";
    }
    public function accounts()
    {
        return $this->hasMany(UserAccount::class);
    }
    public function company()
    {
        return $this->belongsTo(Agent::class, 'agent_id');
    }
    public function agent()
    {
        return $this->belongsTo(Agent::class, 'agent_id');
    }
    public function agents()
    {
        return $this->hasManyThrough(
            Agent::class,
            UserAccount::class,
            'user_id',       // Foreign key on user_accounts
            'id',          // Local key on ledger_accounts
            'id',            // Local key on users
            'agent_id'     // Foreign key on user_accounts to ledger_accounts
        );
    }
    public function isAgent()
    {
        // Example logic: you can adapt to your own structure
        return $this->role === 'agent' || !is_null($this->agent_id);
    }
    public function isAdmin()
    {
        return is_null($this->agent_id);
    }
}
