<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TransferPackageDetail extends Model
{
    protected $table = "transfer_packages_details";
    protected $fillable = ['package_id', 'min_amount', 'max_amount', 'send_fee', 'receive_fee', 'another_fee', 'send_fee_type', 'receive_fee_type'];

    // Each detail belongs to one package
    public function package()
    {
        return $this->belongsTo(TransferPackage::class, 'package_id');
    }
}
