<?php

namespace App\Models;

use Abivia\Ledger\Models\JournalEntry;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class JournalEntryOverwrite   extends JournalEntry
{
  protected $casts = [
    'extra' => 'array', // لتحويل JSON إلى array تلقائياً
  ];

  protected $table = "journal_entries";
  public function  transfer()
  {
    return $this->belongsTo(\App\Models\LedgerTransfer::class, 'transfer_id')->withoutGlobalScopes();
  }
  public function currencyrelation()
  {
    return $this->belongsTo(\App\Models\Currency::class, 'currency');
  }
  public function account()
  {
    return $this->belongsTo(\App\Models\LedgerAccountOverwrite::class, 'account_id');
  }
}
