<?php

namespace App\Models;

use App\Traits\HasAvatar;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\HasMedia;

class ApiConfig extends Model implements HasMedia
{
    use HasAvatar;
    use InteractsWithMedia;
    protected $fillable = ['agent_id', 'name', 'api_type_id', 'base_url', 'config_json'];

    public function getLogo()
    {
        $model = $this;
        $media = $model->getMedia('logo');

        if ($media->count() > 0) {
            return  $media[0]->getUrl();
        } else {

            return   "";
        }
    }
    public function agent()
    {
        return $this->belongsTo(Agent::class);
    }
    public function apiType()
    {
        return $this->belongsTo(ApiType::class);
    }
}
