<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgentCurrencyVisibility extends Model
{
    protected $table = 'agent_currency_visibility';
    protected $fillable = ['agent_id', 'currency_code', 'can_send', 'can_receive'];
    public  function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_code', 'code');
    }
    public function agent()
    {
        return $this->belongsTo(Agent::class, 'agent_id', 'id');
    }
}
