<?php

namespace App\Livewire\Transfers;

use App\Models\LedgerTransfer;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Statistics extends Component
{
    public $statsByCurrency = [];

    public function mount()
    {
        $currencies = LedgerTransfer::whereNull('deleted_at')
            ->select('currency')
            ->distinct()
            ->pluck('currency');

        foreach ($currencies as $currency) {
            $query = LedgerTransfer::where('currency', $currency)->Transfer();

            $this->statsByCurrency[$currency] = [
                'totalTransfers' => $query->count(),
                'totalAmount' => $query->sum('amount'),
                'avgAmount' => $query->avg('amount'),
                'totalFees' => $query->sum(DB::raw('send_fee + receiver_fee')),
                'delivered' => (clone $query)->whereNotNull('delivered_at')->count(),
            ];
        }
    }

    public function render()
    {
        return view('livewire.transfers.statistics');
    }
}
