<?php

namespace App\Livewire\Transfers;

use App\Models\LedgerTransfer;
use Livewire\Component;

class ShowTransferMedia extends Component
{
    public int $transfer_id;
    public array $mediaFiles = []; // ✅ Always an empty array by default
    public bool $showModal = false;
    protected $listeners = ['ShowTransferMedia' => 'loadMedia'];

    public function loadMedia($transfer_id, $model = "LedgerTransfer"): void
    {
        $this->mediaFiles = [];
        $this->transfer_id = (int) $transfer_id;
        $class = "App\Models\\" . $model;
        $transfer = $class::find($this->transfer_id);

        if ($transfer) {
            // Group all media by collection name
            foreach ($transfer->media->groupBy('collection_name') as $collectionName => $mediaItems) {
                $this->mediaFiles[$collectionName] = $mediaItems->map(function ($media) {
                    return [
                        'id'       => $media->id,
                        'name'     => $media->name,
                        'url'      => $media->getFullUrl(),
                        'download' => $media->getFullUrl(),
                        'mime'     => $media->mime_type ?? '', // ✅ Avoid undefined array key
                    ];
                })->toArray();
            }
        } else {
            $this->mediaFiles = []; // ✅ Reset to empty if not found
        }
        $this->showModal = true;
        $this->dispatch('open_modal', ['action' => 'show', 'id' => 'transferMediaModal']);
    }
    public function render()
    {
        return view('livewire.transfers.show-transfer-media');
    }
}
