<?php

namespace App\Livewire\Transfers;

use Livewire\Component;
use App\Models\Agent;
use App\Models\TransferPackage;

class AllocatePackageToAgent extends Component
{
    public $selectedAgentId, $selectedAgentIds = [];
    public $availableAgents = [];
    public $packages = [];
    public $assignedPackageIds = [];
    protected function  getListeners()
    {
        return [
            'updatedSelectedAgentId' => 'loadPackagesAndAssignments',
            'AssignPackageToAgent' => 'AssignPackageToAgent'
        ];
    }
    public function AssignPackageToAgent($id)
    {
        $package = TransferPackage::find($id);
        $this->assignedPackageIds[] = $id;
        $this->dispatch("open_modal", ['action' => "show", "id" => "AllocatePackageToAgentModal"]);
    }
    public function mount()
    {
        // Load all agents for the dropdown (id => name)
        $this->availableAgents = Agent::pluck('name', 'id')->toArray();
    }

    public function updatedSelectedAgentId()
    {
        if ($this->selectedAgentId == "all") {
            $this->selectedAgentIds = Agent::pluck('id')->toArray();
        } else {
            $this->selectedAgentIds = [$this->selectedAgentId];
        }
        $this->loadPackagesAndAssignments();
    }

    protected function loadPackagesAndAssignments()
    {


        // Get all packages that are either global or assigned to this agent
        $this->packages = TransferPackage::where("agent_id", $this->selectedAgentId)->orwherenull('agent_id')->get();

        if ($this->selectedAgentId == "all") {
            $this->assignedPackageIds = TransferPackage::pluck('id')->toArray();
        } else
            // Get IDs of packages assigned to this agent
            $this->assignedPackageIds = Agent::find($this->selectedAgentId)
                ->transferPackages()
                ->pluck('package_id') // or just 'id' if relation is standard
                ->toArray();
    }

    public function saveAssignments()
    {
        if (!$this->selectedAgentId) {
            session()->flash('error', 'Please select an agent.');
            return;
        }

        $agents = Agent::wherein('id', $this->selectedAgentIds)->get();

        foreach ($agents as $agent) {
            $agent->transferPackages()->sync($this->assignedPackageIds);
        }

        // Sync selected packages to agent


        session()->flash('success', 'Package assignments saved.');
    }
    public function render()
    {
        return view('livewire.transfers.allocate-package-to-agent');
    }
}
