<?php

namespace App\Livewire\StatementReport;

use Abivia\Ledger\Models\JournalEntry;
use App\Models\Currency;
use Carbon\Carbon;
use Livewire\Component;
use Illuminate\Support\Facades\Validator;

class Filter extends Component
{
  public $currencies = [];
  public $accounts = [];
  public $dateFilter = 'custom'; // القيمة الافتراضية

  public $fromDate;
  public $toDate;
  public $currency;
  public $accountId;
  public $account;
  public $showFilter = false;

  protected  function getListeners()
  {
    return [
      'toggleChangeStatementReview' => 'UpdateReview',
      "SetFilterAgentId" => "SetFilterAgentId"
    ];
  }
  public function SetFilterAgentId($data)
  {

    $this->account = $data['account'];
  }
  public function onDateFilterChange()
  {
    switch ($this->dateFilter) {
      case 'today':
        $this->fromDate = Carbon::today()->format('Y-m-d');
        $this->toDate = Carbon::today()->format('Y-m-d');
        break;

      case 'this_month':
        $this->fromDate = Carbon::now()->startOfMonth()->format('Y-m-d');
        $this->toDate = Carbon::now()->endOfMonth()->format('Y-m-d');
        break;

      case 'this_year':
        $this->fromDate = Carbon::now()->startOfYear()->format('Y-m-d');
        $this->toDate = Carbon::now()->endOfYear()->format('Y-m-d');
        break;

      case 'all':
        $this->fromDate = null;
        $this->toDate = null;
        break;

      case 'custom':
      default:
        // لا تغير التاريخ تلقائيًا، المستخدم سيختار يدويًا
        break;
    }
  }
  public  function UpdateReview($value, $checked)
  {


    $entry = JournalEntry::find($value);
    $entry->reviewed = $checked;
    $entry->save();
  }
  public function mount()
  {

    $this->accounts = \App\Models\CustomLedgerAccount::where('category', false)
      ->where(function ($query) {
        $query->where('extra->type', '!=', 'cashier')->orwherenull('extra->type');
      })
      ->get();
    $this->currencies = \App\Models\Currency::all();
    $this->fromDate = session('statement_filter.fromDate', now()->subMonth()->format('Y-m-d'));
    $this->toDate = session('statement_filter.toDate', now()->format('Y-m-d'));
    $this->currency = session('statement_filter.currency');
    $this->accountId = session('statement_filter.accountId');
    $this->dateFilter = session('statement_filter.dateFilter', 'custom');

    if ($this->accountId) {
      $this->account = $this->accountId;
    }
  }
  public  function updated()
  {
    $currency = Currency::where('code', $this->currency)->first();
    // if ($currency && $this->accountId) {
    $this->account = $this->accountId; //getAgentAccountCode($this->accountId, '11');

    // }

  }
  public function  applyFilter()
  {
    $rules = [
      'fromDate' => 'required|date',
      'toDate' => 'required|date',
      'currency' => 'required',
      'accountId' => 'required',
    ];
    $validator = Validator::make($this->all(), $rules);
    if ($validator->fails()) {
      $this->dispatch('sweetalert:error', ['msg' => $validator->errors()->first(), 'title' => 'Error', 'type' => 'error']);
      return;
    }
    session([
      'statement_filter.fromDate' => $this->fromDate,
      'statement_filter.toDate' => $this->toDate,
      'statement_filter.currency' => $this->currency,
      'statement_filter.accountId' => $this->accountId,
      'statement_filter.dateFilter' => $this->dateFilter,
    ]);

    $this->dispatch('SetAgentId', ['agentId' => $this->accountId]);
    $selectedFilters = [
      'fromDate' => $this->fromDate,
      'toDate' => $this->toDate,
      'currency' => $this->currency,
      'accountId' => $this->accountId,
      'account' => $this->account,
    ];
    $this->dispatch('filtersApplied', ["filters" => $selectedFilters, "table_id" => "transaction-table"]);
    $this->dispatch('SetBalanceReconciliationAccountId', ['accountId' => $this->accountId]);
  }
  public function render()
  {
    return view('livewire.statement-report.filter');
  }
}
