<?php

namespace App\Livewire\Settings\Tabs;

use App\Models\Template;
use Livewire\Component;
use Rawilk\Settings\Facades\Settings;

class Reciepts extends Component
{
    public array $types = ['transfer', 'delivery', 'exchange', 'booking'];
    public array $selectedTemplates = [];
    public $templates = [];
    public function mount()
    {
        foreach ($this->types as $type) {
            $this->selectedTemplates[$type] = Settings::get("default_template.$type") ?? null;
            if ($type === 'delivery') {
                $this->selectedTemplates['delivery'] =  Settings::get("default_template.transfer");
            }
        }
        $templates = Template::all()->groupBy('type');
        $this->templates = $templates->toArray();
    }

    public function save()
    {
        foreach ($this->selectedTemplates as $type => $templateId) {
            Settings::set("default_template.$type", $templateId);
        }

        session()->flash('success', 'Template settings updated successfully.');
    }
    public function render()
    {
        return view('livewire.settings.tabs.reciepts');
    }
}
