<?php

namespace App\Livewire\Settings\Tabs;

use Livewire\Component;
use Livewire\WithFileUploads;
use Rawilk\Settings\Contracts\Setting;
use Rawilk\Settings\Facades\Settings;

class BalanceReconciliation extends Component
{
    use WithFileUploads;
    public $background;
    public $background_image;
    public $balance_reconciliation_content;
    public $written_balance_reconciliation_content;
    public  function mount()
    {
        $this->background_image = Settings::get('balance_reconciliation_background_image', null);
        if ($this->background_image) {
            $this->background_image = 'storage/backgrounds/' . $this->background_image;
        } else {
            $this->background_image = null;
        }
        $this->balance_reconciliation_content =  Settings::get('balance_reconciliation_content', '');
        $this->written_balance_reconciliation_content =  Settings::get('written_balance_reconciliation_content', '');
    }

    public  function save()
    {
        // $this->validate([
        //     'background' => 'image|max:1024', // 1MB Max
        // ]);

        if ($this->background) {
            $this->background->store('backgrounds', 'public');
            Settings::set('balance_reconciliation_background_image', $this->background->hashName());
        }

        Settings::set('balance_reconciliation_content', $this->balance_reconciliation_content);
        Settings::set('written_balance_reconciliation_content', $this->written_balance_reconciliation_content);
        $this->dispatch("sweetalert:success", [
            'msg' => 'Balance Reconciliation settings updated successfully',
            'title' => 'Success',
            'icon' => 'success'
        ]);
    }
    public function render()
    {
        return view('livewire.settings.tabs.balance-reconciliation');
    }
}
