<?php

namespace App\Livewire\Settings\Tabs;

use Livewire\Component;
use Rawilk\Settings\Facades\Settings;

class Agent extends Component
{
    public $agent = [
        'show_based_balance' => 0,
        'advanced_transfer_status' => 0
    ];
    public function SaveAgentSettings()
    {
        foreach ($this->agent as $key => $value) {
            Settings::set("agent.$key", $value);
        }
        $this->dispatch("sweetalert:success", [
            'msg' => 'Agent settings updated successfully',
            'title' => 'Success',
            'icon' => 'success'
        ]);
    }
    public function mount()
    {
        foreach ($this->agent as $key => $default) {
            $this->agent[$key] = Settings::get("agent.$key", $default);
        }
    }
    public function render()
    {
        return view('livewire.settings.tabs.agent');
    }
}
