<?php

namespace App\Livewire\Rules;

use App\Models\FraudRule;
use Livewire\Component;

class AddFraudRule extends Component
{
    public   $rulesJson;
    protected function getListeners()
    {
        return [
            'saveRules' => 'saveRules'
        ];
    }
    public function loadRules()
    {
        $rule = FraudRule::find(2);
        $this->dispatch('loadBuilderRules', payload: json_decode($rule->rule_json, true));
    }

    public function saveRules($rulesJson)
    {

        FraudRule::create([
            'name' => 'قاعدة جديدة',
            'rule_json' => $rulesJson,
            'active' => true,
        ]);

        $this->dispatch('sweetalert:success', ['msg' => 'تم حفظ القاعدة']);
    }
    public  function mount()
    {
        $this->loadRules();
    }
    public function render()
    {
        return view('livewire.rules.add-fraud-rule');
    }
}
