<?php

namespace App\Livewire;

use App\Models\LedgerTransfer;
use Livewire\Component;

class GlobalSearch extends Component
{
    public string $query = '';
    public $results = [];

    public function updatedQuery()
    {
        if (strlen($this->query) < 2) {
            $this->results = [];
            return;
        }

        $this->results = LedgerTransfer::search($this->query)->take(10)->get();
    }

    public function render()
    {
        return view('livewire.global-search');
    }
}
