<?php

namespace App\Livewire\Components;

use App\Models\OtherInfo as ModelsOtherInfo;
use Livewire\Component;

class OtherInfo extends Component
{
    public $infoableType;
    public $infoableId;

    public $otherInfos = [];

    public function mount($infoableType, $infoableId)
    {
        $this->infoableType = $infoableType;
        $this->infoableId = $infoableId;

        $this->otherInfos = ModelsOtherInfo::where('infoable_type', $infoableType)
            ->where('infoable_id', $infoableId)
            ->get()
            ->map(fn($info) => ['type' => $info->type, 'value' => $info->value])
            ->toArray();
    }

    public function addRow()
    {
        $this->otherInfos[] = ['type' => '', 'value' => ''];
    }

    public function removeRow($index)
    {
        unset($this->otherInfos[$index]);
        $this->otherInfos = array_values($this->otherInfos); // reindex
    }

    public function render()
    {
        return view('livewire.components.other-info');
    }
}
