<?php

namespace App\Livewire\Components;

use App\Models\ExpenseCategory;
use Livewire\Component;

class JsTree extends Component
{
    public $treeId;
    public $event = 'nodeSelected';

    public function mount($treeId = 'tree')
    {
        $this->treeId = $treeId;
    }
    public function getChildren($id = null)
    {
        $query = $id ? ExpenseCategory::where('parent_id', $id) : ExpenseCategory::whereNull('parent_id');

        return $query->get()->map(function ($cat) {
            return [
                'id' => $cat->id,
                'text' => $cat->name,
                'children' => $cat->children()->exists()
            ];
        })->toArray();
    }
    public function render()
    {
        return view('livewire.components.js-tree');
    }
}
