<?php

namespace App\Livewire\Components;

use App\Enums\WalletSlug;
use App\Models\Account;
use App\Models\Invoice;
use App\Models\Tenant;
use App\Models\User;

use Livewire\Component;
use Illuminate\Support\Str;
use Livewire\WithFileUploads;
use App\Services\PaymentHandlers\PaymentService;
use Illuminate\Support\Facades\Log;

class CollectionForm extends Component
{
    use WithFileUploads;
    public  $tenants, $tenant, $tenant_id;
    public $search_account, $showOtherAccounts = false, $showTerminations = false;
    public $selected_account, $amount, $currency = 'TRY', $bank, $date;
    public $collectionType = 'Collection', $receipt, $description;
    public $accounts = [];
    public  $banks;
    public $contract, $contractId;
    public  $action = "deposit";
    public $transactions = [];
    public $collection_date;
    public $showmainaccount = false;
    public  $invoices;
    public  $extraPayment = 0;
    public  $banktransaction = null;
    public $policy;
    public $modal_title = "Collection";
    public  function UpdatedShowmainaccount($value)
    {

        $this->LoadWallets();
    }
    public function UpdatedTenantId()
    {
        $this->tenant = User::find($this->tenant_id);
        $this->LoadWallets();
        $this->loadInvoices();
        $this->makeCalculation();
    }

    protected function  getListeners()
    {
        return [
            'showCollectionForm' => 'showCollectionForm',
            'BanktransactionTypeChanged' => 'BanktransactionTypeChanged',
            'PayPolicy' => 'PayPolicy',
            'PolicyTahsilati' => 'PolicyTahsilati'
        ];
    }
    public function BanktransactionTypeChanged($payload)
    {


        $id = $payload['id'] ?? null;
        $type = $payload['type'] ?? null;


        if ($type == 4 || $type == 6) {
            $type == 4 ? $this->action = "payment" : $this->action = "rent_tahsilati";
            $this->modal_title = GetActionTitle($this->action);
            $banktransaction = \App\Models\BankTransaction::find($id);
            $banktransaction->type = $type;
            if ($banktransaction->status == "approved" && $banktransaction->balance <= 0) {
                $this->dispatch("sweetalert:error", [
                    'title' => 'Error',
                    'msg' => 'Payment already approved',
                ]);
                return;
            }
            $this->banktransaction = $banktransaction;
            $this->tenant = $banktransaction->user ?? $this->tenant;
            $this->tenant_id = $this->tenant->id ?? null;
            $this->description = $banktransaction->description;
            $this->amount = $banktransaction->amount;
            $this->currency = $banktransaction->currency;

            $this->LoadWallets();
            $this->loadInvoices();
            $this->makeCalculation();
            $this->dispatch("open_modal", ['action' => "show", "id" => "collectionModal"]);
        }
    }
    public  function  PayPolicy($id)
    {

        $policy = \App\Models\Policy::find($id);
        $this->policy = $policy;
        $contract = $policy->contract;

        $this->showCollectionForm($contract->id ?? null, "policy_odeme");
        $this->loadInvoices();
    }
    public  function PolicyTahsilati($id)
    {
        $policy = \App\Models\Policy::find($id);
        $this->policy = $policy;
        $contract = $policy->contract;
        $this->tenant = $contract->tenant ?? null;
        $this->showCollectionForm($contract->id ?? null, "policy_tahsilati");
        $this->LoadWallets();

        $this->loadInvoices();
    }
    public function showCollectionForm($contract_id, $action)
    {
        $this->modal_title = GetActionTitle($action);
        $this->action = $action;
        $this->contract = \App\Models\Contract::find($contract_id);

        $this->tenant = optional($this->contract)->tenant != null ? optional($this->contract)->tenant : $this->tenant;
        $this->tenant_id = $this->tenant->id ?? null;
        if ($this->contract)
            $this->LoadWallets();
        $this->dispatch("open_modal", [
            "id" => "collectionModal",
            "action" => "show"
        ]);
    }
    public function loadInvoices()
    {

        $this->invoices = []; // ← Reset before loading

        $tenant = $this->tenant;
        $invoices =  $tenant != null ? $tenant->OutstandingInvoices() : Invoice::where('id', 0)->get();
        Log::info($this->action);
        if ($this->action == "policy_tahsilati" || $this->action == "policy_odeme") {

            $policy = $this->policy;
            Log::info($policy);


            if ($this->action == "policy_odeme") {
                $invoices = $policy->OutstandingPolicyPayments();
                $this->invoices = $invoices->map(function ($inv) {

                    return [
                        'id' => $inv->id,
                        'type' => $inv->type = "policy Odeme",
                        'description' =>  $inv->notes, // you can make this dynamic
                        'due_date' => $inv->payment_date,
                        'debt' => $inv->amount,
                        'payment' => 0,
                        'delay_fee' => 0,
                        'remaining_amount' => $inv->amount,

                    ];
                })->values()->toArray();
            } else {
                $invoices = $policy->OutstandingInvoices();
                $this->invoices = $invoices->map(function ($inv) {
                    $delayed_fee = $inv->getDelayedFee();
                    return [
                        'id' => $inv->id,
                        'type' =>  "Policy  Tahsilatı",
                        'description' =>  $inv->description, // you can make this dynamic
                        'due_date' => $inv->due_date,
                        'debt' => $inv->remaining_amount,
                        'payment' => 0,
                        'delay_fee' => $delayed_fee,
                        'remaining_amount' => $inv->remaining_amount,

                    ];
                })->values()->toArray();
            }
        } else {
            if ($this->action != "policy_tahsilati" && $this->action != "policy_odeme" && isset($invoices) && $invoices->isNotEmpty()) {
                $this->invoices = $invoices->map(function ($inv) {
                    $delayed_fee = $inv->getDelayedFee();
                    return [
                        'id' => $inv->id,
                        'type' => $inv->type == "rent" ? 'Kira Faturası' : 'Kira Faturası',
                        'description' =>  $inv->description, // you can make this dynamic
                        'due_date' => $inv->due_date,
                        'debt' => $inv->remaining_amount,
                        'payment' => 0,
                        'delay_fee' => $delayed_fee,
                        'remaining_amount' => $inv->remaining_amount,

                    ];
                })->values()->toArray();
            } else {
                $this->invoices[] = [
                    'type' => 'Fazla Ödenen Tutar',
                    'description' => null,
                    'due_date' => null,
                    'debt' => 0,
                    'payment' => 0,
                    'delay_fee' => 0,
                    'remaining_amount' => 0,
                ];
            }
        }
    }

    public function updatedInvoices($value, $name)
    {
        $this->makeCalculation();
    }
    public function updatedAmount()
    {
        $this->makeCalculation();
    }
    public function makeCalculation()
    {
        $remaining = $this->amount;

        foreach ($this->invoices as $i => $invoice) {

            $invoiceTotal = ($invoice['debt'] ?? 0) + ($invoice['delay_fee'] ?? 0);

            if ($remaining >= $invoiceTotal) {
                $this->invoices[$i]['payment'] = $invoiceTotal;
                $this->invoices[$i]['remaining_amount'] = 0;
                $remaining -= $invoiceTotal;
            } else {
                $this->invoices[$i]['payment'] = $remaining;
                $this->invoices[$i]['remaining_amount'] = $invoiceTotal - $remaining;

                $remaining = 0;
            }
        }


        $this->extraPayment = $remaining;
    }


    public function showWalletTransactions($wallet_id)
    {

        $this->dispatch('showWalletTransactions', $wallet_id);
    }
    public  function mount()
    {
        $this->tenants = Tenant::get();
        $this->tenant = $this->contract->tenant ?? null;
        $this->LoadWallets();
        $this->loadInvoices();
        $this->banks = Account::get();
    }
    public function LoadWallets()
    {
        $tenant = $this->tenant;

        if ($tenant) {

            $this->accounts = $tenant->wallets()->where(function ($query) {
                $contract = $this->contract;
                if ($this->showmainaccount) {
                    $query->when($contract, function ($query) {
                        return $query->where('contract_id', $this->contract->id);
                    })->orWhere('contract_id', null);
                } else {
                    $query->when($contract, function ($query) {
                        return $query->where('contract_id', $this->contract->id);
                    });
                }
            })->get()->sortBy(function ($wallet) {
                $code = $wallet->meta['cari_code'] ?? '';
                preg_match_all('/\d+/', $code, $matches);
                return array_map('intval', $matches[0]); // returns array like [30, 18, 2, 1, 4]
            })->values();
        }
        switch ($this->action) {
            case "deposit_tahsilati":
                $this->selected_account =  optional(optional($this->contract)->DepositWallet())->id;


                break;
            case "deposit_odeme":
                $this->selected_account = optional(optional($this->contract)->DepositWallet())->id;

                break;
            case "rent_tahsilati":

                $this->selected_account = optional(optional($this->contract)->RentWallet())->id;

                break;
            case "policy_tahsilati":

                $this->selected_account = optional(optional($this->contract)->RentWallet())->id;

                break;
            default:
                $this->selected_account = optional(optional($this->contract)->RentWallet())->id;

                break;
        }
    }
    public function updatedSearchAccount($value)
    {

        $this->showOtherAccounts = false;
        $tenant = $this->contract->tenant;
        if ($value) {

            $this->accounts = $tenant->wallets->where("contract_id", $this->contract->id)->filter(function ($wallet) use ($value) {
                return isset($wallet->meta['cari_code']) &&
                    Str::contains(Str::lower($wallet->meta['cari_code']), Str::lower($value));
            });
        } else {
            $this->accounts = $tenant->wallets->where("contract_id", $this->contract->id);
        }
    }
    public function  UpdatedSelectedAccount($value)
    {
        $this->showOtherAccounts = false;
        if ($value) {
            $account = $this->accounts->firstWhere('id', $value);
            if ($account) {
                $this->currency = $account->currency;
            }
            $transactions = $account->transactions;
            $this->transactions = $transactions;
        }
    }
    public function Save(): void
    {

        $this->validate([

            'bank' => 'required',
        ]);
        try {
            $paymentService = new PaymentService();
            $result = $paymentService->processPayment([
                'policy' => $this->policy,
                'action' => $this->action,
                'amount' => $this->amount,
                'invoices' => $this->invoices,
                'account' => optional($this->accounts)->firstWhere('id', $this->selected_account),
                'bank' => $this->banks->find($this->bank),
                'description' => $this->description,
                'currency' => $this->currency,
                'tenant_id' => $this->tenant_id,
                'banktransaction' => $this->banktransaction,
                'receipt' => $this->receipt,
            ]);
            $this->dispatch("RefreshYajraDatatable", ['table' => 'banktransaction-table']);
            $this->dispatch("sweetalert:success", [
                'title' => 'Success',
                'msg' => $result['message'] ?? 'Transaction completed successfully.',
            ]);
            // $totalUsed = 0;

            // foreach ($this->invoices as $invoice) {
            //     if ($invoice['payment'] > 0 && isset($invoice['id'])) {
            //         // Record the payment for the actual invoice
            //         $inv = \App\Models\Invoice::find($invoice['id']);
            //         if ($inv) {
            //             $inv->pay(now(), $invoice['payment'], $invoice['payment_method'] ?? 1, $this->description, $invoice['reference'] ?? null); // optional method to mark as paid/partial
            //             $this->doTransactions($this->amount, WalletSlug::Deposit, "Fatura Odenmesi", "invoice");

            //             $totalUsed += $invoice['payment'];
            //         }
            //     }
            // }
            // $extra = $this->amount - $totalUsed;

            // if ($extra > 0) {
            //     $this->doTransactions($extra, WalletSlug::Deposit, "Fazla Ödeme", "extra");
            // }
            // if ($this->banktransaction) {
            //     $this->banktransaction->update([

            //         'status' => "approved",
            //         'tenant_id' => $this->tenant_id
            //     ]);
            //     $this->banktransaction->forcewithdraw($this->amount, ['description' => $this->description]);
            // }
            // $this->dispatch("RefreshYajraDatatable", [
            //     'table' => 'banktransaction-table',
            // ]);
            // $this->dispatch("sweetalert:success", [
            //     'title' => 'Success',
            //     'msg' => 'Transaction completed successfully.',
            // ]);
        } catch (\Exception $e) {
            $this->dispatch("sweetalert:error", [
                'title' => 'Error',
                'msg' => $e->getMessage(),
            ]);
        }
    }
    public  function  doTransactions($amount, $slug, $description, $type)
    {
        $account = $this->accounts->firstWhere('id', $this->selected_account);
        $balance = $account->balance;
        $account_currency = $account->currency;
        $bank = $this->banks->find($this->bank);
        $bank_balance = $bank->balance;
        if ($type == "extra") {
            $transaction = $account->currency === $this->currency
                ? $account->deposit($amount, [
                    'action' => $slug,
                    'description' => $this->description ?: $description,
                    'currency' => $this->currency,
                    'from_old_balance' => $balance,
                    'to_old_balance' => $balance,
                ])
                : exchange_deposit($account, $this->amount, $this->currency);
        }
        $bank = $this->banks->find($this->bank);
        $bank_balance = $bank->balance;

        $bank->currency === $this->currency
            ? $bank->deposit($amount, [
                'action' => $slug,
                'description' => $this->description ?: $description,
                'currency' => $this->currency,
                'from_old_balance' => $bank_balance,
                'to_old_balance' => $bank_balance,
            ])
            : exchange_deposit($bank, $this->amount, $this->currency);

        if ($transaction && $this->receipt) {
            $transaction->addMedia($this->receipt->getRealPath())
                ->usingFileName($this->receipt->getClientOriginalName())
                ->toMediaCollection('receipts');
        }
    }
    public function render()
    {
        return view('livewire.components.collection-form');
    }
}
