<?php

namespace App\Livewire\Components;

use Livewire\Component;

class CapturePhoto extends Component
{
    public $photo; // Will store base64 image data

    public function savePhoto()
    {
        if (!$this->photo) {
            $this->dispatchBrowserEvent('notify', ['type' => 'error', 'message' => 'No photo captured!']);
            return;
        }

        // $this->photo is base64 string like "data:image/png;base64,...."
        // We need to decode and save it

        $imageData = $this->photo;
        list($type, $imageData) = explode(';', $imageData);
        list(, $imageData) = explode(',', $imageData);
        $imageData = base64_decode($imageData);

        $fileName = 'capture_' . time() . '.png';
        $filePath = storage_path('app/public/photos/' . $fileName);

        // Make sure directory exists
        if (!file_exists(dirname($filePath))) {
            mkdir(dirname($filePath), 0755, true);
        }

        file_put_contents($filePath, $imageData);

        $this->dispatchBrowserEvent('notify', ['type' => 'success', 'message' => 'Photo saved successfully!']);

        // Optionally clear photo after save
        $this->photo = null;
    }

    public function render()
    {
        return view('livewire.components.capture-photo');
    }
}
