<?php

namespace App\Livewire\Attachment;

use App\Models\AttachmentType;
use Livewire\Component;

class Add extends Component
{
    public $attachmenttype = [];
    public  function addAttachmentType()
    {
        $this->validate([
            'attachmenttype.name' => 'required'
        ]);
        AttachmentType::create($this->attachmenttype);
        $this->dispatch("toastr:success", ['msg' => __("alerts.added_successfully"), "title" => __("alerts.Success"), "type" => "success"]);
        $this->dispatch("refreshAttachmentTypes");
    }
    public function render()
    {
        return view('livewire.attachment.add');
    }
}
