<?php

namespace App\Livewire\Approval;

use App\Exceptions\CreditLimitExceededException;
use App\Models\Agent;
use App\Models\ApiConfig;
use App\Models\Currency;
use App\Models\CustomLedgerAccount;
use App\Models\LedgerApproval;
use App\Services\Transfer\ApprovalService;
use App\Services\TransferCreditLimitValidator;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use OwenIt\Auditing\Events\AuditCustom;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Log;
use Rawilk\Settings\Facades\Settings;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\ValidationException;

class Add extends Component
{
  public $approval = ['type' => 'approval', 'sender_id' => null];
  public $agents = [];
  public  $currencies = [];
  public  $companies = [];
  public $company;
  public $url = "/Agentsearch/Search";
  public $searchUrl = "/Agentsearch/Search";
  public  $api_url;
  public $class;
  public string $createExchangeMessage = '';
  public bool $canCreateExchange = false;
  public  $receiver;
  protected function getListeners()
  {
    return [
      'editApproval' => 'EditApproval',
      'confirmAddApproval' => 'save',
      'BlockTransferConfirm' => 'BlockTransferConfirm',
      'UnblockTransferConfirm' => 'UnblockTransferConfirm',
      'BlockTransfer' => 'BlockTransfer',
      'UnblockTransfer' => 'UnblockTransfer',
    ];
  }
  public function BlockTransferConfirm($id)
  {
    $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'BlockTransfer', 'action' => __("actions.block_transfer"), 'title' => __("actions.block_transfer"), 'data' => ['transfer_id' => $id]]);
  }
  public function UnblockTransferConfirm($id)
  {
    $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'UnblockTransfer', 'action' => __("actions.unblock_transfer"), 'title' => __("actions.unblock_transfer"), 'data' => ['transfer_id' => $id]]);
  }
  public function BlockTransfer($id)
  {
    $transfer = LedgerApproval::find($id);
    BlockTransfer($transfer);
  }
  public function UnblockTransfer($id)
  {
    $transfer = LedgerApproval::find($id);
    UnblockTransfer($transfer);
  }
  public function Updated($key, $value)
  {
    if ($key == "company")
      $this->approval['receiver_account_code'] = null;
    $value = $this->company;

    if ($key == "approval.receiver_account_code") {
      $this->dispatch('sweetalert:success', ['msg' => __("approval.you_selected_agent") . $this->approval['receiver_account_code'], "title" => __("alerts.success"), "type" => "success"]);

      //dd($clientdata);
    }
    if ($value != 0) {
      $currency = $this->approval['currency'];

      $config = ApiConfig::find($value);
      $class = $config->apiType->class_name;
      $this->class = $class;
      $this->url = $this->url . "?id=$value";
      $this->searchUrl = $this->searchUrl . "?api_id=$value&currency=$currency";
    } else {
      $this->url = "/Agentsearch/Search";
      $this->searchUrl = "/Agentsearch/Search";
    }
    $this->checkBalance();
  }


  public function getSearchUrlProperty()
  {
    return  $this->url . "?id=$this->company";
  }
  public function EditApproval($id)
  {
    $approval = LedgerApproval::find($id);
    $this->receiver = $approval->receiver;
    $this->approval = $approval->toArray();

    $this->dispatch("open_modal", ['action' => 'show', 'id' => 'AddNewApprovalModal']);
  }
  public function mount()
  {
    $this->agents = LedgerApproval::GetSourceAgents();
    $this->currencies = Currency::get();
    $localCompany = [Settings::get('general.company_name') => 0];
    $this->companies = $localCompany + getAPICompanies();
    $response = Gate::inspect('create', \App\Models\LedgerApproval::class);

    $this->canCreateExchange = $response->allowed();
    $this->createExchangeMessage = $response->message() ?? '';
  }
  public  function sendConfirm()
  {
    $rules = [
      'approval.sender_id' => 'required',
      'approval.receiver_account_code' => 'required',
      'approval.receiver_id' => 'required|different:approval.sender_id',

      'approval.amount' => 'required',
      'approval.currency' => 'required',

    ];
    try {
      $this->approval['receiver_id'] = $this->approval['receiver_account_code'];
      $receiver_id = $this->approval['receiver_account_code'];
      $this->validate($rules);
      $title = __("alerts.add_approval");
      $action = __("actions.add");
      if (isset($this->approval['id']) && $this->approval['id'] != null) {
        $title = __("alerts.edit_approval");
        $action = __("actions.edit");
      }
      $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'confirmAddApproval', 'action' => $action, 'title' => $title, 'data' => []]);
    } catch (ValidationException $e) {
      $firstField = array_key_first($e->validator->errors()->messages());
      $this->dispatch('focus-error', ['field' => $firstField]);

      $firstErrorMessage = $e->validator->errors()->first($firstField);
      $this->dispatch("sweetalert:error", [
        'msg' => $firstErrorMessage,
        'title' => __("alerts.error"),
        'type' => "error"
      ]);
    } catch (\Exception $e) {
      DB::rollBack();
      Log::error($e);
      $this->dispatch("sweetalert:error", ['msg' => $e->getMessage(), "title" => "Error", "type" => "error"]);
    }
  }
  public  function UpdateApproval()
  {
    $id = $this->approval['id'];
    $approval = LedgerApproval::find($id);
    $approval->update($this->approval);
    $receiver_id = $this->approval['receiver_account_code'];
    if ($this->company != 0) {
      $class = $this->class;
      $service_api = new $class();
      $config = ApiConfig::find($this->company);
      $configArray = json_decode($config->config_json, true);
      $configArray['base_url'] = $config->base_url;

      $service_api->setConfig($configArray);
      $config = ApiConfig::find($this->company);
      $this->approval['receiver_account_code'] = $config->agent_id;
      $this->approval['receiver_id'] = $config->agent_id;
      $array =  $this->approval;
      $array['receiver_id'] = $receiver_id;
      $result = $service_api->UpdateApproval($array);

      if ($result['success'] == false) {
        $this->dispatch("sweetalert:error", ['msg' =>  $result['message'], "title" => __("Error"), "type" => "error"]);
        $this->dispatch("UnBlockUI");
        return;
      }
    } else {

      $service = new ApprovalService();
      $res = $service->UpdateLedger($approval);
      if ($res['success'] == false) {
        $this->dispatch("sweetalert:error", ['msg' =>  $res['message'], "title" => __("Error"), "type" => "error"]);
        $this->dispatch("UnBlockUI");
        return;
      }
      $this->dispatch("sweetalert:success", ['msg' =>  $res['message'], "title" => __("Success"), "type" => "success"]);
    }
    $this->dispatch("open_modal", ['action' => 'hide', 'id' => 'AddNewApprovalModal']);

    $this->dispatch("UnBlockUI");
  }

  public function save()
  {

    $rules = [
      'approval.sender_id' => 'required',
      'approval.receiver_account_code' => 'required',
      'approval.amount' => 'required',
      'approval.currency' => 'required',

    ];
    $this->approval['receiver_id'] = $this->approval['receiver_account_code'];
    $receiver_id = $this->approval['receiver_account_code'];

    try {
      $this->validate($rules);
      if (isset($this->approval['id']) && $this->approval['id'] != null) {
        $this->UpdateApproval();
        return;
      }

      //
      DB::beginTransaction();
      $this->approval['reference'] = $this->generateRandomTransferNumber();
      if ($this->company != 0) {
        $class = $this->class;
        $service_api = new $class();
        $config = ApiConfig::find($this->company);
        $configArray = json_decode($config->config_json, true);
        $configArray['base_url'] = $config->base_url;

        $service_api->setConfig($configArray);
        $config = ApiConfig::find($this->company);
        $this->approval['receiver_account_code'] = $config->agent_id;
        $this->approval['receiver_id'] = $config->agent_id;
        $array =  $this->approval;
        $array['receiver_id'] = $receiver_id;
        $result = $service_api->sendApproval($array);

        if ($result['success'] == false) {
          $this->dispatch("sweetalert:error", ['msg' =>  $result['message'], "title" => __("Error"), "type" => "error"]);
          return;
        } else {
          $this->approval['status'] = 'Completed';
          $this->approval['external_ref'] =   $result['ref'];
        }
      }
      $transfer = $this->approval;
      $transfer['delivery_amount'] = $transfer['amount'];
      $transfer['delivery_currency'] = $transfer['currency'];

      LedgerApproval::disableAuditing();
      $service = new ApprovalService();

      $transfer = $service->create($transfer);

      DB::commit();

      LedgerApproval::enableAuditing();
      $transfer->auditEvent = 'Create_Approval';
      $transfer->isCustomEvent = true;
      $transfer->auditCustomOld = [];

      $transfer->auditCustomNew = [
        "sender" => $transfer->sender->name  ?? "",
        "receiver" => $transfer->receiver->name ?? "",
        "amount" => $transfer->amount,

        "sender_fee" => $transfer->sender_fee,
        "delivery_amount" => $transfer->amount,
        "currency" => $transfer->currency,
        "delivery_currency" => $transfer->currency,

      ];

      // Step 6: Dispatch the custom audit event
      Event::dispatch(new AuditCustom($transfer));
      $transfer->disableAuditing();

      //  $this->UploadAttatchments($transfer->id);
      $this->dispatch("RefreshYajraDatatable", ['table' => 'approval-table']);
      $this->dispatch("RefreshYajraDatatable", ['table' => 'livewatch-table']);
      $this->dispatch("sweetalert:success", ['msg' =>  __("transfers.transfer_created_successfully_toast", ['reference' => $transfer->reference, 'amount' => $transfer->amount, 'currency' => $transfer->currency]), "title" =>  __("alerts.success"), "type" => "success"]);
      $this->dispatch('ShowTransferReceipt', ['transfer_id' => $transfer['id']]);
      $this->resetForm();
      $this->dispatch("open_modal", ['action' => 'hide', 'id' => 'AddNewApprovalModal']);
      $this->dispatch("UnBlockUI");
    } catch (ValidationException $e) {
      $firstField = array_key_first($e->validator->errors()->messages());
      $this->dispatch('focus-error', ['field' => $firstField]);
      DB::rollBack();
      $firstErrorMessage = $e->validator->errors()->first($firstField);
      $this->dispatch("sweetalert:error", [
        'msg' => $firstErrorMessage,
        'title' => __("alerts.error"),
        'type' => "error"
      ]);
    } catch (\Exception $e) {
      DB::rollBack();
      Log::error($e);
      $this->dispatch("sweetalert:error", ['msg' => $e->getMessage(), "title" => "Error", "type" => "error"]);
    } finally {
      Log::info('Transfer added', ['transfer' => $this->approval]);
    }


    $this->dispatch("UnBlockUI");
  }
  public function resetForm()
  {
    $approval = ['type' => 'approval', 'sender_id' => null];
    $this->approval = [
      'type' => 'approval',
      'reference' => '',
      'sender_id' => null,
      'receiver_id' => null,
      'currency' => null,
      'amount' => null,
      'sender_fee' => 0,
      'receiver_fee' => 0,
      'status' => 'pending',
    ];
    $this->dispatch("open_modal", ['action' => 'hide', 'id' => 'AddNewApprovalModal']);
  }
  public function checkBalance(): void
  {
    if ($this->approval['sender_id'] == null || !array_key_exists('amount', $this->approval) || $this->approval['amount'] == null || !array_key_exists('currency', $this->approval) || $this->approval['currency'] == null) {
      return;
    }
    $sender = Agent::find($this->approval['sender_id']);

    if (null === $sender) {
      $this->addError('balance', __('Sender Not Found'));

      return;
    }

    try {
      (new TransferCreditLimitValidator())->validate(
        $sender,
        $this->transfer['currency'] ?? '',
        (int) ($this->approval['amount'] + ($this->approval['send_fee'] ?? 0)),
        "approval"
      );
    } catch (CreditLimitExceededException $e) {
      $this->addError('balance', $e->getMessage());
    }
  }

  public function  getBalances($agent_id)
  {
    Log::info("agent_id   " . $agent_id);
    if (!$agent_id) {
      return [];
    }
    $agent = Agent::where("id", $agent_id)->first();
    if (!$agent) {
      return [];
    }
    return $agent->getAgentBalances();
  }
  public function generateRandomTransferNumber(): string
  {
    $branchCode = str_pad(mt_rand(0, 999), 3, '0', STR_PAD_LEFT);
    $transactionId = str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);

    return "APR-{$branchCode}-{$transactionId}";
  }

  public function render()
  {
    return view('livewire.approval.add');
  }
}
