<?php

namespace App\Livewire\Agents;

use App\Models\Agent;
use Livewire\Component;

class RevenuePercent extends Component
{
    public $agent;
    public $revenue_percent = ['outcome' => 0, 'income' => 0];
    protected function getListeners()
    {
        return [
            'SetRevenuePercent' => 'SetRevenuePercent'
        ];
    }
    public function save()
    {
        $rules = [
            'revenue_percent.outcome' => 'required|numeric|min:0|max:100',
            'revenue_percent.income' => 'required|numeric|min:0|max:100',
        ];
        $this->validate($rules);
        try {
            $this->agent->revenuepercent()->updateOrCreate(['agent_id' => $this->agent->id], $this->revenue_percent);
            $this->dispatch("open_modal", ['action' => "hide", "id" => "RevenuePercentModal"]);
            $this->dispatch('sweetalert:success', ['msg' => __("alerts.updated_successfully"), "title" => __("alerts.success"), "type" => "success"]);
        } catch (\Exception $e) {
            $this->dispatch('sweetalert:error', ['msg' => __("alerts.error_occured"), "title" => __("alerts.error"), "type" => "error"]);
        }
    }
    public function SetRevenuePercent($id)
    {
        $this->agent = Agent::find($id);
        $this->revenue_percent = optional(optional($this->agent->revenuepercent())->first())->toArray() ?? ['outcome' => 0, 'income' => 0];
        $this->dispatch("open_modal", ['action' => "show", "id" => "RevenuePercentModal"]);
    }
    public function render()
    {
        return view('livewire.agents.revenue-percent');
    }
}
