<?php

namespace App\Livewire\AgentPanel\Transfer;

use App\Exceptions\CreditLimitExceededException;
use App\Models\Agent;
use App\Models\ApiConfig;
use App\Models\Currency;
use App\Models\CustomLedgerAccount;
use App\Models\LedgerApproval;
use App\Services\Transfer\ApprovalService;
use App\Services\TransferCreditLimitValidator;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use OwenIt\Auditing\Events\AuditCustom;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Log;
use Rawilk\Settings\Facades\Settings;
use Illuminate\Support\Facades\Gate;

class AddApproval extends Component
{
    public $approval = ['type' => 'approval', 'sender_id' => null, 'receiver_id' => null, 'amount' => null];
    public $agents = [];
    public  $currencies = [];
    public  $companies = [];
    public $company;
    public $url = "/Agentsearch/Search";
    public $searchUrl = "/Agentsearch/Search";
    public  $api_url;
    public $class;
    public string $createExchangeMessage = '';
    public bool $canCreateExchange = false;
    public $send_flag = false;
    public  $receiver;
    public  $config;
    public $logo;
    protected function getListeners()
    {
        return [
            'editApproval' => 'EditApproval',
            'confirmAddApproval' => 'save',
        ];
    }
    public function Updated($key, $value)
    {
        if ($key == "company")
            $this->approval['receiver_account_code'] = null;
        $value = $this->company;
        if ($key == "approval.receiver_account_code") {
            $receiver = Agent::find($this->approval['receiver_account_code']);
            $this->dispatch('sweetalert:success', ['msg' => __("approval.you_selected_agent") . $receiver->name, "title" => __("alerts.success"), "type" => "success"]);

            //dd($clientdata);
        }
        try {
            $currency = $this->approval['currency'];
            if ($value != 0) {
                $config = ApiConfig::find($value);
                $this->config = $config;
                $this->logo = $config->getLogo();



                $class = $config->apiType->class_name;
                $this->class = $class;
                $this->url = $this->url . "?id=$value";
                $this->searchUrl = $this->searchUrl . "?api_id=$value&currency=$currency";
            } else {
                $this->logo =    '/storage/Logo/' . Settings::get('logo', null);
                $this->url = "/Agentsearch/Search?type=approval&currency=$currency&direction=receiver";
                $this->searchUrl = "/Agentsearch/Search?type=approval&currency=$currency&direction=receiver";
            }
            $this->CheckBalance();
            $this->getFee();
        } catch (\Exception $e) {
            Log::info($e);
        }
    }


    public function getSearchUrlProperty()
    {
        return  $this->url . "?id=$this->company";
    }
    public function EditApproval($id)
    {
        $approval = LedgerApproval::find($id);
        $this->receiver = $approval->receiver;
        $this->approval = $approval->toArray();

        $this->dispatch("open_modal", ['action' => 'show', 'id' => 'AddNewApprovalModal']);
    }
    public function mount()
    {
        $this->logo =    '/storage/Logo/' . Settings::get('logo', null);
        $this->approval['sender_id'] = auth()->guard('agent')->user()->agent->id;
        $this->agents = LedgerApproval::GetSourceAgents();
        $this->currencies = Currency::get();

        $localCompany = [Settings::get('general.company_name') => 0];
        $this->companies = $localCompany + getAPICompanies();
        $response = Gate::inspect('create', \App\Models\LedgerApproval::class);

        $this->canCreateExchange = $response->allowed();
        $this->createExchangeMessage = $response->message() ?? '';
    }
    public  function sendConfirm()
    {
        $rules = [
            'approval.sender_id' => 'required',
            'approval.receiver_account_code' => 'required',
            'approval.amount' => 'required',
            'approval.currency' => 'required',

        ];
        $this->approval['receiver_id'] = $this->approval['receiver_account_code'];

        $this->validate($rules);
        $this->CheckBalance();
        $title = __("alerts.add_approval");
        $action = __("actions.add");
        if (isset($this->approval['id']) && $this->approval['id'] != null) {
            $title = __("alerts.edit_approval");
            $action = __("actions.edit");
        }
        $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'confirmAddApproval', 'action' => $action, 'title' => $title, 'data' => []]);
    }
    public  function UpdateApproval()
    {
        $id = $this->approval['id'];
        $approval = LedgerApproval::find($id);
        $approval->update($this->approval);
        $receiver_id = $this->approval['receiver_account_code'];
        if ($this->company != 0) {
            $class = $this->class;
            $service_api = new $class();
            $config = ApiConfig::find($this->company);
            $configArray = json_decode($config->config_json, true);
            $configArray['base_url'] = $config->base_url;

            $service_api->setConfig($configArray);
            $config = ApiConfig::find($this->company);
            $this->approval['receiver_account_code'] = $config->agent_id;
            $this->approval['receiver_id'] = $config->agent_id;
            $array =  $this->approval;
            $array['receiver_id'] = $receiver_id;
            $result = $service_api->UpdateApproval($array);

            if ($result['success'] == false) {
                $this->dispatch("sweetalert:error", ['msg' =>  $result['message'], "title" => __("Error"), "type" => "error"]);
                $this->dispatch("UnBlockUI");
                return;
            }
        } else {

            $service = new ApprovalService();
            $res = $service->UpdateLedger($approval);
            if ($res['success'] == false) {
                $this->dispatch("sweetalert:error", ['msg' =>  $res['message'], "title" => __("Error"), "type" => "error"]);
                $this->dispatch("UnBlockUI");
                return;
            }
            $this->dispatch("sweetalert:success", ['msg' =>  $res['message'], "title" => __("Success"), "type" => "success"]);
        }
        $this->dispatch("open_modal", ['action' => 'hide', 'id' => 'AddNewApprovalModal']);

        $this->dispatch("UnBlockUI");
    }
    public  function ResetForm()
    {
        $this->approval = ['type' => 'approval',   'receiver_id' => null, 'amount' => null, 'receiver_account_code' => null];
        $this->approval['sender_id'] = auth()->guard('agent')->user()->agent->id;
        $this->send_flag = false;

        $this->mount();
    }

    public function save()
    {

        $rules = [
            'approval.sender_id' => 'required',
            'approval.receiver_account_code' => 'required',
            'approval.amount' => 'required',
            'approval.currency' => 'required',

        ];
        $this->approval['receiver_id'] = $this->approval['receiver_account_code'];
        $receiver_id = $this->approval['receiver_account_code'];
        $this->validate($rules);
        try {

            if (isset($this->approval['id']) && $this->approval['id'] != null) {
                $this->UpdateApproval();
                return;
            }

            //
            $this->approval['reference'] = $this->generateRandomTransferNumber();
            if ($this->company != 0) {
                $class = $this->class;
                $service_api = new $class();
                $config = ApiConfig::find($this->company);
                $configArray = json_decode($config->config_json, true);
                $configArray['base_url'] = $config->base_url;

                $service_api->setConfig($configArray);
                $config = ApiConfig::find($this->company);
                $this->approval['receiver_account_code'] = $config->agent_id;
                $this->approval['receiver_id'] = $config->agent_id;
                $array =  $this->approval;
                $array['receiver_id'] = $receiver_id;
                $result = $service_api->sendApproval($array);

                if ($result['success'] == false) {
                    $this->dispatch("sweetalert:error", ['msg' =>  $result['message'], "title" => __("Error"), "type" => "error"]);
                    return;
                } else {
                    $this->approval['status'] = 'Completed';
                    $this->approval['external_ref'] =   $result['ref'];
                }
            }
            $transfer = $this->approval;
            $transfer['delivery_amount'] = $transfer['amount'];
            $transfer['delivery_currency'] = $transfer['currency'];

            LedgerApproval::disableAuditing();
            $service = new ApprovalService();

            $transfer = $service->create($transfer);



            LedgerApproval::enableAuditing();
            $transfer->auditEvent = 'Create_Approval';
            $transfer->isCustomEvent = true;
            $transfer->auditCustomOld = [];

            $transfer->auditCustomNew = [
                "sender" => $transfer->sender->name  ?? "",
                "receiver" => $transfer->receiver->name ?? "",
                "amount" => $transfer->amount,

                "sender_fee" => $transfer->sender_fee,
                "delivery_amount" => $transfer->amount,
                "currency" => $transfer->currency,
                "delivery_currency" => $transfer->currency,

            ];

            // Step 6: Dispatch the custom audit event
            Event::dispatch(new AuditCustom($transfer));
            $transfer->disableAuditing();

            //  $this->UploadAttatchments($transfer->id);
            $this->dispatch("RefreshYajraDatatable", ['table' => 'approval-table']);
            $this->dispatch("RefreshYajraDatatable", ['table' => 'livewatch-table']);
            $this->dispatch("sweetalert:success", ['msg' =>  __("transfers.transfer_created_successfully_toast", ['reference' => $transfer->reference, 'amount' => $transfer->amount, 'currency' => $transfer->currency]), "title" =>  __("alerts.success"), "type" => "success"]);
            $this->dispatch('ShowTransferReceipt', ['transfer_id' => $transfer['id']]);
            $this->resetForm();
            $this->dispatch("open_modal", ['action' => 'hide', 'id' => 'AddNewApprovalModal']);
            $this->dispatch("UnBlockUI");
        } catch (\Exception $e) {
            Log::info($e);
            session()->flash('error', 'Transfer failed: ' . $e->getMessage());
        }
        $this->dispatch("UnBlockUI");
    }
    public function CheckBalance()
    {
        try {
            $currency = $this->approval['currency'] ?? "";
            $amount = $this->approval['amount'];
            $send_fee = $this->approval['send_fee'] ?? 0;
            $agent = auth()->guard('agent')->user()->agent;


            if ($agent) {
                $creditlimitValidator = new TransferCreditLimitValidator();
                $creditlimitValidator->validate($agent, $currency, $amount + $send_fee, "approval");
                $this->send_flag = true;
                Log::debug("CheckBalance: No exception, send_flag set to true");
            } else {
                $this->addError('balance', "Agent not found");
                $this->send_flag = false;
                Log::debug("CheckBalance: Agent not found, send_flag set to false");
            }
        } catch (CreditLimitExceededException $e) {
            Log::debug("CheckBalance: Credit limit exception caught, setting send_flag to false");
            Log::error($e);
            $this->addError('balance', $e->getMessage());
            $this->send_flag = false;
        } catch (\Exception $e) {
            Log::debug("CheckBalance: General exception caught, setting send_flag to false");
            Log::error($e);
            $this->send_flag = false;
            $this->addError('balance', $e->getMessage());
        }

        Log::debug("CheckBalance END: send_flag is " . var_export($this->send_flag, true));
    }
    public function  getFee()
    {

        $sender = Agent::find($this->approval['sender_id']);

        $receiver = Agent::find($this->approval['receiver_id']);
        if ($sender) {
            $sender_package = $sender->CurrencyApprovalPackages($this->approval['currency']);

            if ($sender_package && $this->approval['amount'] != 0 && isset($this->approval['amount'])) {
                $fees = getFeePriceFromPackage($sender_package->id, $this->approval['amount']);

                if (!$fees['status']) {

                    $this->dispatch("sweetalert:error", ['msg' => $fees['msg'], "title" => "Error", "type" => "error"]);
                    $this->send_flag = false;
                    return;
                }
                $this->send_flag = true;
                $this->approval['send_fee'] = $fees['send_fee'];
            } elseif ($this->approval['amount'] != 0 && isset($this->approval['amount'])) {
                $this->dispatch("sweetalert:error", ['msg' => __("transfers.fee_package_not_found"), "title" => "Error", "type" => "error"]);
                $this->send_flag = false;
                return;
            }
        }
        if ($receiver) {
            $receiver_package = $receiver->CurrencyApprovalPackages($this->approval['currency']);

            if ($receiver_package && $this->approval['amount'] != 0 && isset($this->approval['amount'])) {
                $fees = getFeePriceFromPackage($receiver_package->id, $this->approval['amount']);


                $this->approval['receiver_fee'] = $fees['receive_fee'];
            }
        }
    }

    public function  getBalances($agent_id)
    {
        Log::info("agent_id   " . $agent_id);
        if (!$agent_id) {
            return [];
        }
        $agent = Agent::where("id", $agent_id)->first();
        if (!$agent) {
            return [];
        }
        return $agent->getAgentBalances();
    }
    public function generateRandomTransferNumber(): string
    {
        $branchCode = str_pad(mt_rand(0, 999), 3, '0', STR_PAD_LEFT);
        $transactionId = str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);

        return "APR-{$branchCode}-{$transactionId}";
    }


    public function render()
    {
        return view('livewire.agent-panel.transfer.add-approval');
    }
}
