<?php

namespace App\Livewire\AgentPanel;

use App\Models\Agent;
use App\Models\Currency;
use App\Models\CustomLedgerAccount;
use App\Models\LedgerExchange;
use Livewire\Component;
use Rawilk\Settings\Facades\Settings;

class BalanceReconciliation extends Component
{


  public  $agent_id;
  public $agent;
  public $currencies = [];
  public  $balances = [];
  public $background;
  public $background_image;
  public $balance_reconciliation_content;
  public $written_balance_reconciliation_content;
  public $type = "exchange";
  public $accounts = "agent";
  protected function getListeners()
  {
    return [
      'SetAgentId' => 'SetAgentId',

    ];
  }
  public function  SetAgentId($data)
  {
    $this->agent_id = $data['agentId'];
    $agentId = $data['agentId'];
    $this->UpdatedAgentId($agentId);
  }
  public  function  UpdatedAgentId($value)
  {

    if ($this->type == "exchange") {
      $this->agent = Agent::find($value);
      $this->balances = $this->getBalances();
      $this->balance_reconciliation_content = $this->parseVariables(Settings::get('balance_reconciliation_content', ''));
      $this->written_balance_reconciliation_content = $this->parseVariables(Settings::get('written_balance_reconciliation_content', ''));
      $this->dispatch("SetExchangeAgent", ['agent_id' => $value]);
    } else {
      $this->SetBalanceReconciliationAccountId($value);
    }
  }
  public  function  SetBalanceReconciliationAccountId($accountId)
  {
    try {

      $account_id = $accountId;

      $account = CustomLedgerAccount::where('code', $account_id)->first();

      $this->balances = optional($account)->getAgentBalances() ?? [];

      $this->balance_reconciliation_content = $this->parseAccountVariables(Settings::get('balance_reconciliation_content', ''));
      $this->written_balance_reconciliation_content = $this->parseAccountVariables(Settings::get('written_balance_reconciliation_content', ''));
    } catch (\Exception $e) {
      dd($e);
    }
  }

  public function mount($type, $accounts = "agent")
  {

    $this->type = $type;
    $this->accounts = $accounts;
    $this->currencies = Currency::get();

    $this->background = Settings::get('balance_reconciliation_background_image', null);
    if ($this->background) {
      $this->background_image = 'storage/backgrounds/' . $this->background;
    } else {
      $this->background_image = null;
    }
    $this->balance_reconciliation_content =  $this->parseVariables(Settings::get('balance_reconciliation_content', ''));

    $this->written_balance_reconciliation_content =  $this->parseVariables(Settings::get('written_balance_reconciliation_content', ''));
    if (isset($account_code)) {
      $this->agent_id = $account_code;

      $this->SetBalanceReconciliationAccountId($account_code);
    }
  }

  protected function parseVariables($html)
  {
    $based_balance = getBaseCurrencyBalance($this->getBalances($this->agent_id));
    $companyName = Settings::get('general.company_name');
    return str_replace([
      '%company_name%',
      '%date%',
      '%based_balance%'
    ], [
      $companyName, // Or get from DB
      now()->format('Y-m-d'),
      format_money($based_balance, "USD")
    ], $html);
  }
  protected function parseAccountVariables($html)
  {
    $based_balance = getBaseCurrencyBalance($this->balances);

    $companyName = Settings::get('general.company_name');
    return str_replace([
      '%company_name%',
      '%date%',
      '%based_balance%'
    ], [
      $companyName, // Or get from DB
      now()->format('Y-m-d'),
      format_money($based_balance, "USD")
    ], $html);
  }

  public function getBalances()
  {
    if (!$this->agent) {
      return [];
    }

    return $this->agent->getAgentBalances();
  }
  public function render()
  {
    return view('livewire.agent-panel.balance-reconciliation');
  }
}
