<?php

namespace App\Livewire\AgentPanel\Auth;

use Livewire\Component;
use Illuminate\Support\Facades\Hash;

class ChangePassword extends Component
{
    public $password, $password_confirmation, $old_password;
    public $user;
    public $company, $root;
    public $logo;
    protected $messages = [
        'password.regex' => 'Password must contain at least one letter, one number and one special character.',
    ];
    protected $rules = [
        'password' => ['required', 'string', 'min:10', 'confirmed', 'regex:/^(?=.*[a-zA-Z])(?=.*[0-9])(?=.*[!@#$%^&*])[a-zA-Z0-9!@#$%^&*]/'],
    ];
    public function mount()
    {
        $this->user = auth()->user();
        $this->old_password = $this->user->password;
        $this->company = $this->user->company;
    }
    public  function ChangePassword()
    {

        $user = $this->user;
        $password = $this->password;
        $this->validate();
        if (Hash::check($this->password, $this->old_password)) {
            $this->dispatch('sweetalert:error', ['msg' => __('New password cannot be the same as the old password.')]);
            return false;
        }
        try {
            $user->password = Hash::make($password);
            $user->password_changed = 1;
            $user->save();
            return redirect()->route('agent.dashboard');
        } catch (\Exception $e) {
            $this->dispatch('toastr:error', ['msg' => $e->getMessage()]);
        }
    }
    public function render()
    {
        return view('livewire.agent-panel.auth.change-password');
    }
}
