<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Agent;
use App\Models\AgentCurrencyCreditLimit;
use App\Models\Currency;
use App\Models\AgentCurrencyVisibility;
use App\Models\AgentGlobalCreditLimit;
use Illuminate\Support\Facades\Log;

class AgentCreditSettings extends Component
{
  public Agent $agent;
  public $currencies;
  public  $global = ['base_credit_limit' => 0, 'approval_credit_limit' => 0, 'transfer_status' => false, 'send_transfer' => false, 'send_approval' => false, 'approval_status' => true];
  public  $general_global = ['base_credit_limit' => 0, 'approval_credit_limit' => 0, 'transfer_status' => false, 'send_transfer' => false, 'send_approval' => false, 'approval_status' => true];
  public float $globalTransferCredit = 0;
  public float $globalAccreditationCredit = 0;
  public $transfer_status = false;
  public $type = "currency";

  public $visibility = []; // ['USD' => ['send' => true, 'receive' => false, 'limit' => 1000], ...]
  public  $general_visibility = [];
  public  $currecnyCreditLimit = [];
  public  $general_currecnyCreditLimit = [];

  public function mount(Agent $agent)
  {
    Log::info($agent);
    $this->agent = $agent;
    $this->currencies = Currency::get();

    $this->global = $agent->getTransferGlobalCreditLimit()?->toArray() ??  ['base_credit_limit' => 0, 'approval_credit_limit' => 0, 'transfer_status' => false, 'send_transfer' => false, 'send_approval' => false, 'approval_status' => true];


    $this->currecnyCreditLimit = $agent->CurrencyCreditLimit
      ->keyBy('currency_code')
      ->map(fn($item) => [
        'credit_limit' => (float) $item->credit_limit,
      ])
      ->toArray();

    foreach ($this->currencies as $currency) {
      $vis = $agent->currencyVisibilities->firstWhere('currency_code', $currency->code);
      $this->visibility[$currency->code] = [
        'send' => (bool) $vis?->can_send,
        'receive' => (bool) $vis?->can_receive,
        'limit' => (float) $vis?->credit_limit,
      ];
      $this->general_visibility[$currency->code] = [
        'send' => false,
        'receive' => false,
        'limit' => null,
      ];
    }
  }
  public function updated()
  {
    $this->updatedVisibility();
    //  $this->updatedGlobalTransferCredit();
    // $this->updatedGlobalAccreditationCredit();
    $this->UpdatedCurrencyCreditLimit();
  }
  public function updatedTransferStatus($value)
  {

    try {
      $this->updatedGlobalTransferCredit();
    } catch (\Exception $e) {
      $this->dispatch("sweetalert:error", ['msg' => $e->getMessage(), 'title' => "Error", 'type' => "error"]);
    }
  }
  public function updatedVisibility()
  {

    foreach ($this->visibility as $code => $data) {
      $currency = $this->currencies->firstWhere('code', $code);
      if (!$currency) continue;

      AgentCurrencyVisibility::updateOrCreate(
        [
          'agent_id' => $this->agent->id,
          'currency_code' => $code,
        ],
        [
          'can_send' => $data['send'],
          'can_receive' => $data['receive'],
          'credit_limit' => $data['limit'],
          'currency_id' => $currency->id,
        ]
      );
    }
  }

  public function UpdatedGlobal()
  {

    $base_currency = Currency::where("is_default", 1)->first()->code ?? "USD";
    $status = $this->transfer_status;

    $config = AgentGlobalCreditLimit::updateOrCreate(
      [
        'agent_id' => $this->agent->id,
        'base_currency_code' => $base_currency,


      ],
      [
        'send_transfer' => $this->global['send_transfer'],
        'send_approval' => $this->global['send_approval'],
        'base_credit_limit' => $this->global['base_credit_limit'],
        'approval_credit_limit' => $this->global['approval_credit_limit'],
        'transfer_status' => $this->global['transfer_status'],
        'approval_status' => $this->global['approval_status']
      ]
    );
  }

  // public function updatedGlobalAccreditationCredit()
  // {
  //     $base_currency = Currency::where("is_default", 1)->first()->code ?? "USD";
  //     AgentGlobalCreditLimit::updateOrCreate(
  //         [
  //             'agent_id' => $this->agent->id,
  //             'base_currency_code' => $base_currency,
  //             'type' => 'approval'
  //         ],
  //         [
  //             'credit_limit' => $this->globalAccreditationCredit,

  //         ]
  //     );
  // }
  public function  UpdatedCurrencyCreditLimit()
  {

    foreach ($this->currecnyCreditLimit as $code => $data) {
      $currency = $this->currencies->firstWhere('code', $code);
      if (!$currency) continue;

      AgentCurrencyCreditLimit::updateOrCreate(
        [
          'agent_id' => $this->agent->id,
          'currency_code' => $code,
        ],
        [


          'credit_limit' => $data['credit_limit'],

        ]
      );
    }
  }









  public function applyToAllAgents()
  {
    $agents = Agent::all();

    foreach ($agents as $agent) {
      $this->applySettingsToAgent($agent);
    }

    $this->dispatch("sweetalert:success", [
      'msg' => __("Settings applied to all agents successfully!"),
      'title' => __("Success")
    ]);
  }

  public function applyToAgentsWithoutConfig()
  {
    $agents = Agent::whereDoesntHave('TransferGlobalCreditLimit')
      ->WhereDoesntHave('CurrencyCreditLimit')
      ->WhereDoesntHave('currencyVisibilities')
      ->get();

    foreach ($agents as $agent) {
      $this->applySettingsToAgent($agent);
    }

    $this->dispatch("sweetalert:success", [
      'msg' => __("Settings applied to agents without config successfully!"),
      'title' => "Success"
    ]);
    $this->dispatch("open_modal", ['id' => "creditSettingsModal", 'action' => 'hide']);
  }

  protected function applySettingsToAgent(Agent $agent)
  {
    // Global Credit Limit
    $base_currency = Currency::where("is_default", 1)->first()->code ?? "USD";

    AgentGlobalCreditLimit::updateOrCreate(
      [
        'agent_id' => $agent->id,
        'base_currency_code' => $base_currency,
      ],
      [
        'send_transfer' => $this->general_global['send_transfer'],
        'send_approval' => $this->general_global['send_approval'],
        'base_credit_limit' => $this->general_global['base_credit_limit'],
        'transfer_status' => $this->general_global['transfer_status'],
        'approval_status' => $this->general_global['approval_status']
      ]
    );

    // Per-Currency Credit Limits
    foreach ($this->general_currecnyCreditLimit as $code => $data) {
      $currency = $this->currencies->firstWhere('code', $code);
      if (!$currency) continue;

      AgentCurrencyCreditLimit::updateOrCreate(
        [
          'agent_id' => $agent->id,
          'currency_code' => $code,
        ],
        [
          'credit_limit' => $data['credit_limit'],
        ]
      );
    }

    // Currency Visibility
    foreach ($this->general_visibility as $code => $data) {
      $currency = $this->currencies->firstWhere('code', $code);
      if (!$currency) continue;

      AgentCurrencyVisibility::updateOrCreate(
        [
          'agent_id' => $agent->id,
          'currency_code' => $code,
        ],
        [
          'can_send' => $data['send'] ?? 0,
          'can_receive' => $data['receive'] ?? 0,
          'credit_limit' => $data['limit'] ?? null,
          'currency_id' => $currency->id,
        ]
      );
    }
    $this->dispatch("RefreshYajraDatatable", ['table' => "creditsetting-table"]);
    $this->dispatch("open_modal", ['id' => "creditSettingsModal", 'action' => 'hide']);
  }

  public function render()
  {
    return view('livewire.agent-credit-settings');
  }
}
