<?php

namespace App\Livewire\Admin;

use App\Models\FormFieldConfig;
use Livewire\Component;

class FormFieldConfigManager extends Component
{
    public $formName = 'transfer_form';
    public $fields = [];
    protected  function  getListeners()
    {
        return [
            'openFormConfigModal' => 'openFormConfigModal'
        ];
    }
    public function openFormConfigModal($formName)
    {
        $this->formName = $formName;
        $this->loadFields();
        $this->dispatch("open_modal", ['action' => "show", 'id' => "FormConfigModal"]);
    }
    public function mount()
    {
        $this->loadFields();
    }
    public function onVisibleChange($index)
    {
        // If visible is false, required must also be false
        if (isset($this->fields[$index])) {
            if (!$this->fields[$index]['visible']) {
                $this->fields[$index]['required'] = false;
            }
        }
    }


    public function onAlwaysRequiredChange($index)
    {
        if (isset($this->fields[$index])) {
            if ($this->fields[$index]['always_required']) {
                // Force visible and required to true if always_required is true
                $this->fields[$index]['visible'] = true;
                $this->fields[$index]['required'] = true;
            }
        }
    }


    public function loadFields()
    {
        $this->fields = FormFieldConfig::where('form_name', $this->formName)
            ->orderBy('id')
            ->get()
            ->map(function ($field) {
                return [
                    'id' => $field->id,
                    'field' => $field->field,
                    'label' => $field->label,
                    'visible' => (bool) $field->visible,
                    'required' => (bool) $field->required,
                    'always_required' => (bool) ($field->always_required ?? false),
                    'tab_index' => $field->tab_index,
                    'extra' => is_array($field->extra)
                        ? $field->extra
                        : json_decode($field->extra ?? '[]', true),
                ];
            })
            ->toArray();
    }



    public function updatedFields()
    {
        // Live update, optionally save instantly
    }

    public function save()
    {
        foreach ($this->fields as $fieldData) {
            FormFieldConfig::updateOrCreate(
                ['form_name' => $this->formName, 'field' => $fieldData['field']],
                [
                    'label' => $fieldData['label'],
                    'visible' => $fieldData['visible'] ?? false,
                    'required' => $fieldData['required'] ?? false,
                    'extra' => $fieldData['extra'] ?? [],
                    'tab_index' => $fieldData['tab_index'] ?? 1,
                ]
            );
        }

        session()->flash('success', 'Configuration saved successfully.');
        $this->loadFields();
    }

    public function render()
    {
        return view('livewire.admin.form-field-config-manager');
    }
}
