<?php

namespace App\Livewire\Accounts;

use App\Models\Account;
use App\Models\AccountType;
use App\Models\Currency;
use Livewire\Component;


class Add extends Component
{
    public $account = [];
    public $account_types;
    public $step = 1;
    public  $currencies;
    public  $balance = 0;
    protected function getMessages()
    {
        return [
            'account.name.required' => 'Account Name is required',
            'account.account_type_id.required' => 'Account Type is required',
            'account.currency_id.required' => 'Currency is required',
        ];
    }
    public  function  mount()
    {
        $this->account_types = AccountType::get();
        $this->currencies = Currency::get();
        $this->account['account_type_id'] = $this->account_types->first()->id;
        $this->account['currency_id'] = $this->currencies->first()->id;
    }
    public  function  Add()
    {
        $rules = [
            'account.name' => 'required',
            'account.account_type_id' => 'required',
            'account.currency_id' => 'required',
        ];
        $this->validate($rules);

        $inserted_account = Account::create($this->account);
        if ($this->balance > 0) {
            $inserted_account->deposit($this->balance);
        }

        $this->dispatch("sweetalert:success", ['msg' => "Account Added Successfully", "title" => "Success", "type" => "success"]);
        $this->dispatch("open_model", ['action' => "hide", 'id' => "AddAccount"]);
        $this->dispatch("UpdateAccountsList");
    }
    public function render()
    {
        return view('livewire.accounts.add');
    }
}
