<?php

namespace App\Listeners;

use App\Events\LatePaymentDetected; // You can customize event names
use App\Models\NotificationPolicy;
use App\Services\Sms\SmsSender;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendNotificationListener implements ShouldQueue
{
    protected $smsSender;

    public function __construct(SmsSender $smsSender)
    {
        $this->smsSender = $smsSender;
    }

    public function handle($event)
    {
        $subscriber = $event->subscriber;
        $eventType = $event->eventType ?? 'late_payment';

        $policies = NotificationPolicy::with('template')
            ->where('event_type', $eventType)
            ->get();

        foreach ($policies as $policy) {
            $template = $policy->template;
            $content = $this->renderTemplate($template->content, $subscriber);

            match ($policy->channel) {
                'sms' => $this->smsSender->send($subscriber->phone, $content),
                'email' => \Mail::to($subscriber->email)->send(new \App\Mail\GenericMail($template->subject, $content)),
                'whatsapp' => \App\Services\Whatsapp\WhatsAppSender::send($subscriber->whatsapp_number, $content),
                default => null,
            };
        }
    }

    private function renderTemplate($template, $subscriber): string
    {
        $map = [
            '--account_name--' => $subscriber->account_name,
            '--balance--' => $subscriber->balance,
            '--payment_link--' => route('payment', $subscriber->id),
            '--date--' => now()->format('Y-m-d'),
            // Add more dynamic tags here
        ];

        return str_replace(array_keys($map), array_values($map), $template);
    }
}
