<?php

namespace App\Jobs;

use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;  // typo fix: use Queueable, not Foundation\Queue\Queueable
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class ImportRowJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;

    protected string $modelClass;
    protected array $row;
    protected array $fieldMap;

    public function __construct(string $modelClass, array $row, array $fieldMap)
    {
        $this->modelClass = $modelClass;
        $this->row = $row;
        $this->fieldMap = $fieldMap;
    }

    public function handle()
    {
        try {
            $modelData = [];

            foreach ($this->fieldMap as $dbField => $columnKey) {
                Log::info('dbField: ' . $dbField . ' columnKey: ' . $columnKey);
                $modelData[$dbField] = $this->row[$columnKey] ?? null;
            }
            Log::info('Importing row: ', $modelData);

            $this->modelClass::doImport($modelData);
        } catch (Exception $e) {
            Log::info($e);
            Log::error('Error importing row: ' . $e->getMessage());
            $cacheKey = "import_errors_{$this->batchId}";
            $errors = Cache::get($cacheKey, 0);
            Cache::put($cacheKey, $errors + 1, now()->addHours(2));
        }
    }
}
