<?php

namespace App\Jobs;

use App\Services\Ledger\AgentLedgerService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

class CreateNewCurrencyLedgerJob implements ShouldQueue
{
    use Queueable;
    /**
     * The agent for whom the ledger is being created.
     *
     * @var mixed
     */
    public $agent;

    /**
     * The currency for which the ledger is being created.
     *
     * @var mixed
     */
    public $currency;
    /**
     * Create a new job instance.
     */
    public function __construct($currency)
    {

        $this->currency = $currency;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $service = new AgentLedgerService();
        $service->createNewCurrencyCashLedger($this->currency);
    }
}
