<?php

namespace App\Imports;

use Maatwebsite\Excel\Row;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Collection;

class PreviewOnlyImport implements OnEachRow, WithHeadingRow
{
    public $rows;

    public function __construct()
    {
        $this->rows = collect(); // Collect rows for preview
    }

    public function onRow(Row $row)
    {
        $this->rows->push($row->toArray());
    }

    public function getRows(): Collection
    {
        return $this->rows;
    }
}
